/*
 * (c) 2003-2019 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.test.extension.dsl.ee;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.hasSize;
import static org.hamcrest.Matchers.is;
import static org.mule.runtime.app.declaration.api.fluent.ElementDeclarer.forExtension;
import static org.mule.runtime.app.declaration.api.fluent.ElementDeclarer.newListValue;
import static org.mule.runtime.app.declaration.api.fluent.ElementDeclarer.newObjectValue;
import static org.mule.runtime.app.declaration.api.fluent.ElementDeclarer.newParameterGroup;
import static org.mule.runtime.app.declaration.api.fluent.ParameterSimpleValue.cdata;
import static org.mule.runtime.core.api.util.IOUtils.getResourceAsString;
import static org.mule.runtime.internal.dsl.DslConstants.EE_PREFIX;
import static org.mule.test.module.extension.internal.util.ExtensionsTestUtils.compareXML;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.app.declaration.api.OperationElementDeclaration;
import org.mule.runtime.config.api.dsl.ArtifactDeclarationXmlSerializer;
import org.mule.runtime.config.api.dsl.model.DslElementModel;

import java.io.IOException;

import org.junit.Before;
import org.junit.Test;

public class DeclarationBasedElementModelFactoryTestCase extends AbstractElementModelTestCase {

  private final String configFile = "ee-app-declaration.xml";
  private String expectedAppXml;


  @Override
  protected String getConfigFile() {
    return configFile;
  }

  @Before
  public void loadExpectedResult() throws IOException {
    expectedAppXml = getResourceAsString(configFile, getClass());
  }

  @Test
  public void serialize() throws Exception {
    String serializationResult = ArtifactDeclarationXmlSerializer.getDefault(dslContext)
        .serialize(createAppDeclarationWithTransform());
    compareXML(expectedAppXml, serializationResult);
  }

  @Test
  public void resolveTransformToElemenModel() {
    OperationElementDeclaration transform = forExtension(EE_PREFIX)
        .newOperation("transform")
        .withParameterGroup(newParameterGroup("Message")
            .withParameter("setPayload", newObjectValue()
                .withParameter("script", "<![CDATA["
                    + "%output application/java\n"
                    + "                    ---\n"
                    + "                    payload\n"
                    + "                    ]]>")
                .build())
            .withParameter("setAttributes",
                           newObjectValue()
                               .withParameter("script", cdata("attributes")).build())
            .getDeclaration())
        .withParameterGroup(newParameterGroup("Set Variables")
            .withParameter("setVariables",
                           newListValue()
                               .withValue(newObjectValue()
                                   .withParameter("foo", "<![CDATA[fooVarValue]]>")
                                   .withParameter("bar",
                                                  cdata("%output application/java\n"
                                                      + "                    ---\n"
                                                      + "                    null\n"))
                                   .withParameter("zap", "zapResource")
                                   .build())
                               .build())
            .getDeclaration())

        .getDeclaration();
    DslElementModel<OperationModel> transformElement = resolve(transform);

    assertHasParameterGroup(transformElement.getModel(), "Message");
    assertHasParameterGroup(transformElement.getModel(), "Set Variables");

    assertThat(transformElement.getConfiguration().isPresent(), is(true));

    assertElementName(transformElement, "transform");
    assertThat(transformElement.getContainedElements(), hasSize(2));
    assertThat(transformElement.findElement("setPayload").isPresent(), is(true));
    assertThat(transformElement.findElement("setAttributes").isPresent(), is(true));
    assertThat(transformElement.findElement("setVariables").isPresent(), is(true));
  }

}
