/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.extension.dsl.ee;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.mulesoft.mule.runtime.core.api.extension.MuleEeExtensionModelProvider;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.fluent.ConfigurationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConnectionElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConstructElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.OperationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.SourceElementDeclarer;
import org.mule.runtime.config.api.dsl.model.DslElementModel;
import org.mule.runtime.config.api.dsl.model.DslElementModelFactory;
import org.mule.runtime.config.api.dsl.processor.ArtifactConfig;
import org.mule.runtime.config.api.dsl.processor.xml.XmlApplicationServiceRegistry;
import org.mule.runtime.config.internal.ModuleDelegatingEntityResolver;
import org.mule.runtime.config.internal.dsl.xml.XmlNamespaceInfoProviderSupplier;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.core.api.util.xmlsecurity.XMLSecureFactories;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.dsl.api.xml.XmlNamespaceInfoProvider;
import org.mule.runtime.dsl.api.xml.parser.ConfigFile;
import org.mule.runtime.dsl.api.xml.parser.ConfigLine;
import org.mule.runtime.dsl.api.xml.parser.XmlConfigurationDocumentLoader;
import org.mule.runtime.dsl.internal.xml.parser.XmlApplicationParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public abstract class AbstractElementModelTestCase
extends MuleArtifactFunctionalTestCase {
    protected static final String HTTP_LISTENER_CONFIG = "httpListener";
    protected static final String COMPONENTS_FLOW = "testFlow";
    protected static final int LISTENER_PATH = 0;
    protected static final int LOGGER_PATH = 1;
    protected static final int TRANSFORM_PATH = 2;
    protected DslResolvingContext dslContext;
    protected DslElementModelFactory modelResolver;
    protected ApplicationModel applicationModel;
    protected Document doc;

    @Before
    public void setup() throws Exception {
        Set extensions = muleContext.getExtensionManager().getExtensions();
        this.dslContext = DslResolvingContext.getDefault((Set)ImmutableSet.builder().addAll((Iterable)extensions).add((Object)MuleExtensionModelProvider.getExtensionModel()).add((Object)MuleEeExtensionModelProvider.getExtensionModel()).build());
        this.modelResolver = DslElementModelFactory.getDefault((DslResolvingContext)this.dslContext);
    }

    protected boolean isDisposeContextPerClass() {
        return true;
    }

    protected <T extends NamedObject> DslElementModel<T> resolve(ComponentConfiguration component) {
        Optional elementModel = this.modelResolver.create(component);
        MatcherAssert.assertThat((Object)elementModel.isPresent(), (Matcher)Matchers.is((Object)true));
        return (DslElementModel)elementModel.get();
    }

    protected <T extends NamedObject> DslElementModel<T> resolve(ElementDeclaration component) {
        Optional elementModel = this.modelResolver.create(component);
        MatcherAssert.assertThat((Object)elementModel.isPresent(), (Matcher)Matchers.is((Object)true));
        return (DslElementModel)elementModel.get();
    }

    protected ComponentConfiguration getAppElement(ApplicationModel applicationModel, String name) {
        Optional component = applicationModel.findTopLevelNamedComponent(name);
        MatcherAssert.assertThat((Object)component.isPresent(), (Matcher)Matchers.is((Object)true));
        return ((ComponentModel)component.get()).getConfiguration();
    }

    protected <T> DslElementModel<T> getChild(DslElementModel<? extends NamedObject> parent, ComponentConfiguration component) {
        return this.getChild(parent, component.getIdentifier());
    }

    protected <T> DslElementModel<T> getChild(DslElementModel<? extends NamedObject> parent, ComponentIdentifier identifier) {
        Optional elementModel = parent.findElement(identifier);
        MatcherAssert.assertThat((String)String.format("Failed fetching child '%s' from parent '%s'", identifier.getName(), ((NamedObject)parent.getModel()).getName()), (Object)elementModel.isPresent(), (Matcher)Matchers.is((Object)true));
        return (DslElementModel)elementModel.get();
    }

    protected <T> DslElementModel<T> getChild(DslElementModel<? extends NamedObject> parent, String name) {
        Optional elementModel = parent.findElement(name);
        MatcherAssert.assertThat((String)String.format("Failed fetching child '%s' from parent '%s'", name, ((NamedObject)parent.getModel()).getName()), (Object)elementModel.isPresent(), (Matcher)Matchers.is((Object)true));
        return (DslElementModel)elementModel.get();
    }

    private <T> DslElementModel<T> getAttribute(DslElementModel<? extends NamedObject> parent, String component) {
        Optional elementModel = parent.findElement(component);
        MatcherAssert.assertThat((String)String.format("Failed fetching attribute '%s' from parent '%s'", component, ((NamedObject)parent.getModel()).getName()), (Object)elementModel.isPresent(), (Matcher)Matchers.is((Object)true));
        return (DslElementModel)elementModel.get();
    }

    protected ComponentIdentifier newIdentifier(String name, String ns) {
        return ComponentIdentifier.builder().name(name).namespace(ns).build();
    }

    protected void assertHasParameter(ParameterizedModel model, String name) {
        MatcherAssert.assertThat((Object)model.getAllParameterModels().stream().anyMatch(p -> p.getName().equals(name)), (Matcher)Matchers.is((Object)true));
    }

    protected void assertHasParameterGroup(ParameterizedModel model, String name) {
        MatcherAssert.assertThat((Object)model.getParameterGroupModels().stream().anyMatch(p -> p.getName().equals(name)), (Matcher)Matchers.is((Object)true));
    }

    protected void assertAttributeIsPresent(DslElementModel<? extends ParameterizedModel> element, String name) {
        this.assertHasParameter((ParameterizedModel)element.getModel(), name);
        DslElementModel databaseParam = this.getAttribute(element, name);
        MatcherAssert.assertThat((Object)databaseParam.getDsl().supportsAttributeDeclaration(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)databaseParam.getDsl().supportsChildDeclaration(), (Matcher)Matchers.is((Object)false));
    }

    protected void assertElementName(DslElementModel propertiesElement, String name) {
        MatcherAssert.assertThat((Object)propertiesElement.getDsl().getElementName(), (Matcher)Matchers.is((Object)name));
    }

    protected ApplicationModel loadApplicationModel() throws Exception {
        return this.loadApplicationModel(this.getConfigFile());
    }

    protected ApplicationModel loadApplicationModel(String configFile) throws Exception {
        InputStream appIs = Thread.currentThread().getContextClassLoader().getResourceAsStream(configFile);
        Preconditions.checkArgument((appIs != null ? 1 : 0) != 0, (Object)"The given application was not found as resource");
        Document document = XmlConfigurationDocumentLoader.noValidationDocumentLoader().loadDocument(() -> XMLSecureFactories.createDefault().getSAXParserFactory(), (EntityResolver)new ModuleDelegatingEntityResolver(muleContext.getExtensionManager().getExtensions()), configFile, appIs);
        XmlApplicationServiceRegistry customRegistry = new XmlApplicationServiceRegistry((ServiceRegistry)new SpiServiceRegistry(), this.dslContext);
        ConfigLine configLine = (ConfigLine)new XmlApplicationParser(XmlNamespaceInfoProviderSupplier.createFromPluginClassloaders(cl -> customRegistry.lookupProviders(XmlNamespaceInfoProvider.class, cl).stream().collect(Collectors.toList()), Collections.singletonList(AbstractElementModelTestCase.class.getClassLoader()))).parse(document.getDocumentElement()).orElseThrow(() -> new Exception("Failed to load config"));
        ArtifactConfig artifactConfig = new ArtifactConfig.Builder().addConfigFile(new ConfigFile(configFile, Collections.singletonList(configLine))).build();
        return new ApplicationModel(artifactConfig, new ArtifactDeclaration(), uri -> muleContext.getExecutionClassLoader().getResourceAsStream(uri));
    }

    protected String write() throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource source = new DOMSource(this.doc);
        StringWriter writer = new StringWriter();
        transformer.transform(source, new StreamResult(writer));
        return writer.getBuffer().toString().replaceAll("\n|\r", "");
    }

    protected void createAppDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        this.doc = docBuilder.newDocument();
        Element mule = this.doc.createElement("mule");
        this.doc.appendChild(mule);
        mule.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.mulesoft.org/schema/mule/core");
        mule.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", this.getExpectedSchemaLocation());
    }

    protected String getExpectedSchemaLocation() {
        return "http://www.mulesoft.org/schema/mule/core http://www.mulesoft.org/schema/mule/core/current/mule.xsd";
    }

    protected ArtifactDeclaration createAppDeclarationWithTransform() {
        ElementDeclarer http = ElementDeclarer.forExtension((String)"HTTP");
        ElementDeclarer core = ElementDeclarer.forExtension((String)"mule");
        ElementDeclarer ee = ElementDeclarer.forExtension((String)"ee");
        return (ArtifactDeclaration)ElementDeclarer.newArtifact().withGlobalElement((GlobalElementDeclaration)((ConfigurationElementDeclarer)http.newConfiguration("listenerConfig").withRefName(HTTP_LISTENER_CONFIG).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("basePath", "/").getDeclaration())).withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)((ConnectionElementDeclarer)http.newConnection("listener").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("tlsContext", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("key-store", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("path", "ssltest-keystore.jks").withParameter("password", "changeit").withParameter("keyPassword", "changeit").build()).build()).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("host", "localhost").withParameter("port", "49019").withParameter("protocol", "HTTPS").getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName(COMPONENTS_FLOW).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("initialState", "stopped").getDeclaration())).withComponent((ComponentElementDeclaration)((SourceElementDeclarer)((SourceElementDeclarer)http.newSource("listener").withConfig(HTTP_LISTENER_CONFIG)).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("path", "testBuilder").withParameter("responseStreamingMode", "AUTO").withParameter("streamingStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("repeatable-file-store-stream").withParameter("bufferUnit", "KB").withParameter("inMemorySize", "2048").build()).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)core.newOperation("logger").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("message", "#[payload]").getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)ee.newOperation("transform").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Message").withParameter("setPayload", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("script", "<![CDATA[output application/java\n                    ---\n                    payload\n                    ]]>").build()).withParameter("setAttributes", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("resource", "myWeaveResource.dw").build()).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Set Variables").withParameter("setVariables", (ParameterValue)ElementDeclarer.newListValue().withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("variableName", "bar").withParameter("script", "<![CDATA[output application/java\n                    ---\n                    null\n                    ]]>").build()).withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("variableName", "foo").withParameter("resource", "myWeaveResource.dw").build()).build()).getDeclaration())).getDeclaration())).getDeclaration()).getDeclaration();
    }
}

