/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.extension.dsl.ee;

import java.io.IOException;
import java.io.InputStream;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.app.declaration.serialization.ArtifactDeclarationJsonSerializer;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.config.api.dsl.ArtifactDeclarationXmlSerializer;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.test.extension.dsl.ee.AbstractElementModelTestCase;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.skyscreamer.jsonassert.JSONAssert;

public class ArtifactDeclarationSerializerTestCase
extends AbstractElementModelTestCase {
    private String configFile = "ee-app-declaration.xml";
    private String expectedAppXml;
    private ArtifactDeclaration applicationDeclaration;
    private String expectedAppJson;

    @Before
    public void loadExpectedResult() throws IOException {
        this.expectedAppXml = IOUtils.getResourceAsString((String)this.configFile, ((Object)((Object)this)).getClass());
        this.applicationDeclaration = this.createAppDeclarationWithTransform();
        this.expectedAppJson = IOUtils.getResourceAsString((String)"ee-app-declaration.json", ((Object)((Object)this)).getClass());
    }

    protected String[] getConfigFiles() {
        return new String[]{this.configFile};
    }

    @Test
    public void serialize() throws Exception {
        String serializationResult = ArtifactDeclarationXmlSerializer.getDefault((DslResolvingContext)this.dslContext).serialize(this.applicationDeclaration);
        ExtensionsTestUtils.compareXML((String)this.expectedAppXml, (String)serializationResult);
    }

    @Test
    public void loadAndSerialize() throws Exception {
        InputStream configIs = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.configFile);
        ArtifactDeclarationXmlSerializer serializer = ArtifactDeclarationXmlSerializer.getDefault((DslResolvingContext)this.dslContext);
        ArtifactDeclaration artifact = serializer.deserialize(this.configFile, configIs);
        String serializationResult = serializer.serialize(artifact);
        ExtensionsTestUtils.compareXML((String)this.expectedAppXml, (String)serializationResult);
    }

    @Test
    public void serializesToJson() {
        InputStream configIs = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.configFile);
        ArtifactDeclarationXmlSerializer serializer = ArtifactDeclarationXmlSerializer.getDefault((DslResolvingContext)this.dslContext);
        ArtifactDeclaration expectedDeclaration = serializer.deserialize(configIs);
        ArtifactDeclarationJsonSerializer jsonSerializer = ArtifactDeclarationJsonSerializer.getDefault((boolean)true);
        String actualAppJson = jsonSerializer.serialize(expectedDeclaration);
        JSONAssert.assertEquals((String)this.expectedAppJson, (String)actualAppJson, (boolean)true);
    }
}

