/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.extension.dsl.ee;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.app.declaration.api.OperationElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.OperationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ParameterSimpleValue;
import org.mule.runtime.config.api.dsl.ArtifactDeclarationXmlSerializer;
import org.mule.runtime.config.api.dsl.model.DslElementModel;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.test.extension.dsl.ee.AbstractElementModelTestCase;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;

public class DeclarationBasedElementModelFactoryTestCase
extends AbstractElementModelTestCase {
    private final String configFile = "ee-app-declaration.xml";
    private String expectedAppXml;

    protected String getConfigFile() {
        return "ee-app-declaration.xml";
    }

    @Before
    public void loadExpectedResult() throws IOException {
        this.expectedAppXml = IOUtils.getResourceAsString((String)"ee-app-declaration.xml", ((Object)((Object)this)).getClass());
    }

    @Test
    public void serialize() throws Exception {
        String serializationResult = ArtifactDeclarationXmlSerializer.getDefault((DslResolvingContext)this.dslContext).serialize(this.createAppDeclarationWithTransform());
        ExtensionsTestUtils.compareXML((String)this.expectedAppXml, (String)serializationResult);
    }

    @Test
    public void resolveTransformToElemenModel() {
        OperationElementDeclaration transform = (OperationElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)ElementDeclarer.forExtension((String)"ee").newOperation("transform").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Message").withParameter("setPayload", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("script", "<![CDATA[%output application/java\n                    ---\n                    payload\n                    ]]>").build()).withParameter("setAttributes", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("script", ParameterSimpleValue.cdata((String)"attributes")).build()).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Set Variables").withParameter("setVariables", (ParameterValue)ElementDeclarer.newListValue().withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("foo", "<![CDATA[fooVarValue]]>").withParameter("bar", ParameterSimpleValue.cdata((String)"%output application/java\n                    ---\n                    null\n")).withParameter("zap", "zapResource").build()).build()).getDeclaration())).getDeclaration();
        DslElementModel transformElement = this.resolve((ElementDeclaration)transform);
        this.assertHasParameterGroup((ParameterizedModel)transformElement.getModel(), "Message");
        this.assertHasParameterGroup((ParameterizedModel)transformElement.getModel(), "Set Variables");
        MatcherAssert.assertThat((Object)transformElement.getConfiguration().isPresent(), (Matcher)Matchers.is((Object)true));
        this.assertElementName(transformElement, "transform");
        MatcherAssert.assertThat((Object)transformElement.getContainedElements(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)transformElement.findElement("setPayload").isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)transformElement.findElement("setAttributes").isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)transformElement.findElement("setVariables").isPresent(), (Matcher)Matchers.is((Object)true));
    }
}

