/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.test.extension.dsl;

import com.google.common.collect.ImmutableSet;
import com.mulesoft.mule.runtime.core.api.extension.MuleEeExtensionModelProvider;
import java.io.StringWriter;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.custommonkey.xmlunit.DetailedDiff;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.XMLUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.fluent.ConfigurationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConnectionElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConstructElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.OperationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.SourceElementDeclarer;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.config.api.dsl.model.DslElementModel;
import org.mule.runtime.config.api.dsl.model.DslElementModelFactory;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.tck.junit4.rule.DynamicPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractElementModelTestCase
extends MuleArtifactFunctionalTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractElementModelTestCase.class);
    protected static final String HTTP_LISTENER_CONFIG = "httpListener";
    protected static final String COMPONENTS_FLOW = "testFlow";
    protected static final int LISTENER_PATH = 0;
    protected static final int LOGGER_PATH = 1;
    protected static final int TRANSFORM_PATH = 2;
    private final Map<String, ComponentAst> namedTopLevelComponentModels = new HashMap<String, ComponentAst>();
    private Set<ExtensionModel> extensions;
    protected DslResolvingContext dslContext;
    protected DslElementModelFactory modelResolver;
    private AstXmlParser xmlToAstParser;
    protected ArtifactAst applicationModel;
    protected Document doc;
    @Rule
    public DynamicPort port = new DynamicPort("port");

    @Before
    public void setup() throws Exception {
        this.extensions = muleContext.getExtensionManager().getExtensions();
        this.dslContext = DslResolvingContext.getDefault((Set)ImmutableSet.builder().addAll(this.extensions).add((Object)MuleExtensionModelProvider.getExtensionModel()).add((Object)MuleExtensionModelProvider.getTlsExtensionModel()).add((Object)MuleEeExtensionModelProvider.getExtensionModel()).build());
        this.modelResolver = DslElementModelFactory.getDefault((DslResolvingContext)this.dslContext);
        this.xmlToAstParser = AstXmlParser.builder().withExtensionModels(this.extensions).build();
    }

    protected boolean isDisposeContextPerClass() {
        return true;
    }

    protected <T extends NamedObject> DslElementModel<T> resolve(ComponentAst component) {
        Optional elementModel = this.modelResolver.create(component);
        MatcherAssert.assertThat((Object)elementModel.isPresent(), (Matcher)Matchers.is((Object)true));
        return (DslElementModel)elementModel.get();
    }

    protected <T extends NamedObject> DslElementModel<T> resolve(ElementDeclaration component) {
        Optional elementModel = this.modelResolver.create(component);
        MatcherAssert.assertThat((Object)elementModel.isPresent(), (Matcher)Matchers.is((Object)true));
        return (DslElementModel)elementModel.get();
    }

    protected ComponentAst getAppElement(ArtifactAst applicationModel, String name) {
        ComponentAst component = this.namedTopLevelComponentModels.get(name);
        MatcherAssert.assertThat((Object)component, (Matcher)Matchers.notNullValue());
        return component;
    }

    protected <T> DslElementModel<T> getChild(DslElementModel<? extends NamedObject> parent, ComponentIdentifier identifier) {
        Optional elementModel = parent.findElement(identifier);
        MatcherAssert.assertThat((String)String.format("Failed fetching child '%s' from parent '%s'", identifier.getName(), ((NamedObject)parent.getModel()).getName()), (Object)elementModel.isPresent(), (Matcher)Matchers.is((Object)true));
        return (DslElementModel)elementModel.get();
    }

    protected <T> DslElementModel<T> getChild(DslElementModel<? extends NamedObject> parent, String name) {
        Optional elementModel = parent.findElement(name);
        MatcherAssert.assertThat((String)String.format("Failed fetching child '%s' from parent '%s'", name, ((NamedObject)parent.getModel()).getName()), (Object)elementModel.isPresent(), (Matcher)Matchers.is((Object)true));
        return (DslElementModel)elementModel.get();
    }

    private <T> DslElementModel<T> getAttribute(DslElementModel<? extends NamedObject> parent, String component) {
        Optional elementModel = parent.findElement(component);
        MatcherAssert.assertThat((String)String.format("Failed fetching attribute '%s' from parent '%s'", component, ((NamedObject)parent.getModel()).getName()), (Object)elementModel.isPresent(), (Matcher)Matchers.is((Object)true));
        return (DslElementModel)elementModel.get();
    }

    protected ComponentIdentifier newIdentifier(String name, String ns) {
        return ComponentIdentifier.builder().name(name).namespace(ns).build();
    }

    protected void assertHasParameter(ParameterizedModel model, String name) {
        MatcherAssert.assertThat((Object)model.getAllParameterModels().stream().anyMatch(p -> p.getName().equals(name)), (Matcher)Matchers.is((Object)true));
    }

    protected void assertHasParameterGroup(ParameterizedModel model, String name) {
        MatcherAssert.assertThat((Object)model.getParameterGroupModels().stream().anyMatch(p -> p.getName().equals(name)), (Matcher)Matchers.is((Object)true));
    }

    protected void assertAttributeIsPresent(DslElementModel<? extends ParameterizedModel> element, String name) {
        this.assertHasParameter((ParameterizedModel)element.getModel(), name);
        DslElementModel databaseParam = this.getAttribute(element, name);
        MatcherAssert.assertThat((Object)databaseParam.getDsl().supportsAttributeDeclaration(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)databaseParam.getDsl().supportsChildDeclaration(), (Matcher)Matchers.is((Object)false));
    }

    protected void assertElementName(DslElementModel propertiesElement, String name) {
        MatcherAssert.assertThat((Object)propertiesElement.getDsl().getElementName(), (Matcher)Matchers.is((Object)name));
    }

    protected ArtifactAst loadApplicationModel() throws Exception {
        return this.loadApplicationModel(this.getConfigFile());
    }

    protected ArtifactAst loadApplicationModel(String configFile) throws Exception {
        ArtifactAst applicationModel = this.xmlToAstParser.parse(new URI[]{Thread.currentThread().getContextClassLoader().getResource(configFile).toURI()});
        applicationModel.updatePropertiesResolver(param -> {
            if (param.startsWith("${") && param.endsWith("}")) {
                return System.getProperty(param.substring(2, param.length() - 1), param);
            }
            return param;
        });
        this.indexComponentModels(applicationModel);
        return applicationModel;
    }

    private void indexComponentModels(ArtifactAst originalAst) {
        originalAst.topLevelComponentsStream().forEach(componentModel -> componentModel.getComponentId().ifPresent(name -> this.namedTopLevelComponentModels.put((String)name, (ComponentAst)componentModel)));
    }

    protected String write() throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource source = new DOMSource(this.doc);
        StringWriter writer = new StringWriter();
        transformer.transform(source, new StreamResult(writer));
        return writer.getBuffer().toString().replaceAll("\n|\r", "");
    }

    protected void createAppDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        this.doc = docBuilder.newDocument();
        Element mule = this.doc.createElement("mule");
        this.doc.appendChild(mule);
        mule.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.mulesoft.org/schema/mule/core");
        mule.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", this.getExpectedSchemaLocation());
    }

    protected String getExpectedSchemaLocation() {
        return "http://www.mulesoft.org/schema/mule/core http://www.mulesoft.org/schema/mule/core/current/mule.xsd";
    }

    protected ArtifactDeclaration createAppDeclarationWithTransform() {
        ElementDeclarer http = ElementDeclarer.forExtension((String)"HTTP");
        ElementDeclarer core = ElementDeclarer.forExtension((String)"mule");
        ElementDeclarer ee = ElementDeclarer.forExtension((String)"ee");
        return (ArtifactDeclaration)ElementDeclarer.newArtifact().withGlobalElement((GlobalElementDeclaration)((ConfigurationElementDeclarer)http.newConfiguration("listenerConfig").withRefName(HTTP_LISTENER_CONFIG).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("basePath", "/").getDeclaration())).withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)((ConnectionElementDeclarer)http.newConnection("listener").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("tlsContext", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("key-store", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("path", "ssltest-keystore.jks").withParameter("password", "changeit").withParameter("keyPassword", "changeit").build()).build()).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("host", "localhost").withParameter("port", "${port}").withParameter("protocol", "HTTPS").getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName(COMPONENTS_FLOW).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("initialState", "stopped").getDeclaration())).withComponent((ComponentElementDeclaration)((SourceElementDeclarer)((SourceElementDeclarer)http.newSource("listener").withConfig(HTTP_LISTENER_CONFIG)).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("path", "testBuilder").withParameter("responseStreamingMode", "AUTO").withParameter("streamingStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("repeatable-file-store-stream").withParameter("bufferUnit", "KB").withParameter("inMemorySize", "2048").build()).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)core.newOperation("logger").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("message", "#[payload]").getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)ee.newOperation("transform").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Message").withParameter("setPayload", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("script", "<![CDATA[output application/java\n                    ---\n                    payload\n                    ]]>").build()).withParameter("setAttributes", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("resource", "myWeaveResource.dw").build()).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Set Variables").withParameter("variables", (ParameterValue)ElementDeclarer.newListValue().withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("variableName", "bar").withParameter("script", "<![CDATA[output application/java\n                    ---\n                    null\n                    ]]>").build()).withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("variableName", "foo").withParameter("resource", "myWeaveResource.dw").build()).build()).getDeclaration())).getDeclaration())).getDeclaration()).getDeclaration();
    }

    public static void compareXML(String expected, String actual) throws Exception {
        XMLUnit.setNormalizeWhitespace((boolean)true);
        XMLUnit.setIgnoreWhitespace((boolean)true);
        XMLUnit.setIgnoreComments((boolean)true);
        XMLUnit.setIgnoreAttributeOrder((boolean)false);
        Diff diff = XMLUnit.compareXML((String)expected, (String)actual);
        if (!diff.similar() || !diff.identical()) {
            LOGGER.error(actual);
            Assert.fail((String)("Actual XML differs from expected: " + System.lineSeparator() + AbstractElementModelTestCase.buildDifferencesMessage(diff)));
        }
    }

    private static String buildDifferencesMessage(Diff diff) {
        DetailedDiff detDiff = new DetailedDiff(diff);
        List differences = detDiff.getAllDifferences();
        StringBuilder diffLines = new StringBuilder();
        for (Object object : differences) {
            Difference difference = (Difference)object;
            diffLines.append(difference.toString()).append(System.lineSeparator());
        }
        return diffLines.toString();
    }
}

