/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.test.extension.dsl;

import com.mulesoft.mule.test.extension.dsl.AbstractElementModelTestCase;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.app.declaration.serialization.ArtifactDeclarationJsonSerializer;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.fluent.ConstructElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.OperationElementDeclarer;
import org.mule.runtime.ast.api.DependencyResolutionMode;
import org.mule.runtime.config.api.dsl.ArtifactDeclarationXmlSerializer;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.tck.junit4.rule.SystemProperty;
import org.skyscreamer.jsonassert.JSONAssert;

public class ArtifactDeclarationSerializerTestCase
extends AbstractElementModelTestCase {
    @Rule
    public SystemProperty minimalDependencies = new SystemProperty("mule." + DependencyResolutionMode.class.getName(), DependencyResolutionMode.MINIMAL.name());
    private static final boolean UPDATE_EXPECTED_FILES_ON_ERROR = Boolean.getBoolean("mule.appJson.updateExpectedFilesOnError");
    private final String configFile = "ee-app-declaration.xml";
    private String expectedAppXml;
    private ArtifactDeclaration applicationDeclaration;
    private String expectedAppJson;

    @Before
    public void loadExpectedResult() throws IOException {
        this.expectedAppXml = IOUtils.getResourceAsString((String)"ee-app-declaration.xml", ((Object)((Object)this)).getClass());
        this.applicationDeclaration = this.createAppDeclarationWithTransform();
        this.expectedAppJson = IOUtils.getResourceAsString((String)"ee-app-declaration.json", ((Object)((Object)this)).getClass());
    }

    private boolean shouldUpdateExpectedFilesOnError() {
        return UPDATE_EXPECTED_FILES_ON_ERROR;
    }

    protected String[] getConfigFiles() {
        return new String[0];
    }

    @Test
    public void serialize() throws Exception {
        String serializationResult = ArtifactDeclarationXmlSerializer.getDefault((DslResolvingContext)this.dslContext).serialize(this.applicationDeclaration);
        ArtifactDeclarationSerializerTestCase.compareXML(this.expectedAppXml, serializationResult);
    }

    @Test
    public void loadAndSerialize() throws Exception {
        InputStream configIs = Thread.currentThread().getContextClassLoader().getResourceAsStream("ee-app-declaration.xml");
        ArtifactDeclarationXmlSerializer serializer = ArtifactDeclarationXmlSerializer.getDefault((DslResolvingContext)this.dslContext);
        ArtifactDeclaration artifact = serializer.deserialize("ee-app-declaration.xml", configIs);
        String serializationResult = serializer.serialize(artifact);
        ArtifactDeclarationSerializerTestCase.compareXML(this.expectedAppXml, serializationResult);
    }

    @Test
    public void serializesToJson() throws Exception {
        InputStream configIs = Thread.currentThread().getContextClassLoader().getResourceAsStream("ee-app-declaration.xml");
        ArtifactDeclarationXmlSerializer serializer = ArtifactDeclarationXmlSerializer.getDefault((DslResolvingContext)this.dslContext);
        ArtifactDeclaration expectedDeclaration = serializer.deserialize(configIs);
        ArtifactDeclarationJsonSerializer jsonSerializer = ArtifactDeclarationJsonSerializer.getDefault((boolean)true);
        String actualAppJson = jsonSerializer.serialize(expectedDeclaration);
        try {
            JSONAssert.assertEquals((String)this.expectedAppJson, (String)actualAppJson, (boolean)true);
        }
        catch (Throwable t) {
            if (this.shouldUpdateExpectedFilesOnError()) {
                File root = new File(IOUtils.getResourceAsUrl((String)"ee-app-declaration.json", ((Object)((Object)this)).getClass()).toURI()).getParentFile().getParentFile().getParentFile();
                File testDir = new File(root, "src/test/resources");
                File target = new File(testDir, "ee-app-declaration.json");
                FileUtils.stringToFile((String)target.getAbsolutePath(), (String)actualAppJson);
                System.out.println(this.expectedAppJson + " fixed");
            }
            throw t;
        }
    }

    @Test
    public void ignoreUnknownComponentsWhenSerializing() throws Exception {
        ElementDeclarer muleDeclarer = ElementDeclarer.forExtension((String)"mule");
        ArtifactDeclaration artifactDeclaration = (ArtifactDeclaration)ElementDeclarer.newArtifact().withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)muleDeclarer.newConstruct("flow").withComponent((ComponentElementDeclaration)((OperationElementDeclarer)muleDeclarer.newOperation("logger").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("message", "#[payload]").getDeclaration())).getDeclaration())).withRefName("myFlow").getDeclaration()).getDeclaration();
        ArtifactDeclaration artifactDeclarationWithUnknownComponent = (ArtifactDeclaration)ElementDeclarer.newArtifact().withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)muleDeclarer.newConstruct("flow").withComponent((ComponentElementDeclaration)muleDeclarer.newOperation("wrongOperation").getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)muleDeclarer.newOperation("logger").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("message", "#[payload]").getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)muleDeclarer.newOperation("anotherWrongOperation").getDeclaration())).withRefName("myFlow").getDeclaration()).getDeclaration();
        String artifactDeclarationStr = ArtifactDeclarationXmlSerializer.getDefault((DslResolvingContext)this.dslContext).serialize(artifactDeclaration);
        String artifactDeclarationWithUnknownComponentStr = ArtifactDeclarationXmlSerializer.getDefault((DslResolvingContext)this.dslContext).serialize(artifactDeclarationWithUnknownComponent);
        ArtifactDeclarationSerializerTestCase.compareXML(artifactDeclarationStr, artifactDeclarationWithUnknownComponentStr);
    }
}

