/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.test.cache.integration;

import com.mulesoft.mule.test.cache.AbstractCacheFunctionalTestCase;
import io.qameta.allure.Feature;
import jakarta.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.el.ExpressionManager;

@Feature(value="Cache scope")
public class CacheExpressionKeyTestCase
extends AbstractCacheFunctionalTestCase {
    @Inject
    ExpressionManager expressionManager;

    protected String getConfigFile() {
        return "integration/expression-key-generation-coercion.xml";
    }

    @Test
    public void numberAsKey() throws Exception {
        TypedValue<Object> val1 = this.getCacheValue(10);
        TypedValue<Object> val2 = this.getCacheValue(10);
        MatcherAssert.assertThat(val1, (Matcher)CoreMatchers.is(val2));
    }

    @Test
    public void jsonStringAsKey() throws Exception {
        TypedValue evaluate = this.expressionManager.evaluate("output application/json --- 'jsonString'");
        TypedValue<Object> val1 = this.getCacheValue(evaluate);
        TypedValue<Object> val2 = this.getCacheValue(evaluate);
        MatcherAssert.assertThat(val1, (Matcher)CoreMatchers.is(val2));
    }

    @Test
    public void objectCantBeCoerced() throws Exception {
        TypedValue evaluate = this.expressionManager.evaluate("output application/json --- {}");
        TypedValue<Object> val1 = this.getCacheValue(evaluate);
        TypedValue<Object> val2 = this.getCacheValue(evaluate);
        MatcherAssert.assertThat(val1, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not(val2)));
    }

    private TypedValue<Object> getCacheValue(Object cacheKey) throws Exception {
        return ((FlowRunner)((FlowRunner)this.flowRunner("cache").withPayload((Object)Math.random())).withVariable("key", cacheKey)).run().getMessage().getPayload();
    }
}

