/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.test.cache.config;

import com.mulesoft.mule.runtime.cache.api.key.MuleEventKeyGenerator;
import com.mulesoft.mule.runtime.cache.api.response.ResponseGenerator;
import com.mulesoft.mule.test.cache.AbstractCacheFunctionalTestCase;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.api.streaming.object.CursorIteratorProvider;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.StreamingUtils;
import org.mule.runtime.core.api.util.func.CheckedRunnable;

public class CacheConfigTestCase
extends AbstractCacheFunctionalTestCase {
    private static final String GENERATED_KEY = "theKey";
    private static final String GENERATED_RESPONSE = "theResponse";
    private static final String OBJECT_STORE_ID = "objectStore";
    private static final List<String> STREAM_OBJECTS = Arrays.asList("Apple", "Banana", "Kiwi");

    protected String getConfigFile() {
        return "config/cache-config.xml";
    }

    protected boolean isGracefulShutdown() {
        return true;
    }

    @Test
    public void testMessageProcessorDefaultConfig() throws Exception {
        String flowName = "CacheRouterDefault";
        CoreEvent firstResponse = this.runCachedFlow(flowName);
        CoreEvent secondResponse = this.runCachedFlow(flowName);
        MatcherAssert.assertThat((Object)firstResponse.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)secondResponse.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void testMessageProcessorFilterExpressionConfig() throws Exception {
        String flowName = "CacheRouterWithFilterExpression";
        CoreEvent firstResponse = this.runCachedFlow(flowName);
        CoreEvent secondResponse = this.runCachedFlow(flowName);
        MatcherAssert.assertThat((Object)firstResponse.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)secondResponse.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)1));
    }

    @Test
    public void testMessageProcessorCachingStrategyConfig() throws Exception {
        String flowName = "CacheRouterWithGlobalObjectStore";
        String secondFlowName = "CacheRouterWithGlobalObjectStore2";
        CoreEvent firstResponse = this.runCachedFlow(flowName);
        CoreEvent secondResponse = this.runCachedFlow(flowName);
        CoreEvent thirdResponse = this.runCachedFlow(secondFlowName);
        MatcherAssert.assertThat((Object)firstResponse.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)secondResponse.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)thirdResponse.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)0));
        ObjectStore objectStore = (ObjectStore)this.registry.lookupByName(OBJECT_STORE_ID).get();
        MatcherAssert.assertThat((Object)objectStore.allKeys(), (Matcher)IsCollectionWithSize.hasSize((int)1));
    }

    @Test
    public void testMessageProcessorPrivateCachingStrategyConfig() throws Exception {
        String flowName = "CacheRouterWithPrivateObjectStore";
        CoreEvent firstResponse = this.runCachedFlow(flowName);
        CoreEvent secondResponse = this.runCachedFlow(flowName);
        MatcherAssert.assertThat((Object)firstResponse.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)secondResponse.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void testMessageProcessorKeyExpressionConfig() throws Exception {
        String flowName = "CacheRouterWithKeyGenerationExpression";
        CoreEvent firstResponse = this.runCachedFlow(flowName);
        CoreEvent secondResponse = this.runCachedFlow(flowName);
        MatcherAssert.assertThat((Object)firstResponse.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)secondResponse.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)0));
        ObjectStore objectStore = (ObjectStore)this.registry.lookupByName(OBJECT_STORE_ID).get();
        MatcherAssert.assertThat((Object)objectStore.contains("test"), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testMessageProcessorKeyGeneratorConfig() throws Exception {
        String flowName = "CacheRouterWithKeyGenerator";
        CoreEvent firstResponse = this.runCachedFlow(flowName);
        CoreEvent secondResponse = this.runCachedFlow(flowName);
        MatcherAssert.assertThat((Object)firstResponse.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)secondResponse.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)0));
        ObjectStore objectStore = (ObjectStore)this.registry.lookupByName(OBJECT_STORE_ID).get();
        MatcherAssert.assertThat((Object)objectStore.contains(GENERATED_KEY), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void testMessageProcessorResponseGeneratorConfig() throws Exception {
        String flowName = "CacheRouterWithResponseGenerator";
        CoreEvent firstResponse = this.runCachedFlow(flowName);
        CoreEvent secondResponse = this.runCachedFlow(flowName);
        MatcherAssert.assertThat((Object)firstResponse.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)0));
        MatcherAssert.assertThat((Object)secondResponse.getMessage().getPayload().getValue(), (Matcher)Matchers.equalTo((Object)GENERATED_RESPONSE));
    }

    @Test
    public void messageWithRepeatableInputStream() throws Exception {
        this.doTestRepeatableInputStream("CacheRepeatableStream");
    }

    @Test
    public void persistentMessageWithRepeatableInputStream() throws Exception {
        this.doTestRepeatableInputStream("CachePersistentRepeatableStream");
    }

    private void doTestRepeatableInputStream(String flowName) throws Exception {
        this.doMultiple(3, () -> {
            String streamKey = "stream";
            String counter = "counter";
            CoreEvent response = this.runStreamingCachedFlow(flowName);
            Map payload = (Map)response.getMessage().getPayload().getValue();
            CursorStreamProvider stream = (CursorStreamProvider)payload.get("stream");
            MatcherAssert.assertThat((Object)CacheConfigTestCase.toString(stream), (Matcher)Matchers.equalTo((Object)"test"));
            MatcherAssert.assertThat(payload.get("counter"), (Matcher)Matchers.equalTo((Object)0));
        });
    }

    public static String toString(CursorStreamProvider cursorStreamProvider) {
        String string;
        block8: {
            InputStream input = (InputStream)cursorStreamProvider.openCursor();
            try {
                string = IOUtils.toString((InputStream)input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iox) {
                    throw new RuntimeException(iox);
                }
            }
            input.close();
        }
        return string;
    }

    private void doMultiple(int count, CheckedRunnable task) {
        for (int i = 0; i < count; ++i) {
            task.run();
        }
    }

    @Test
    public void messageWithRepeatableIterator() throws Exception {
        this.doTestRepeatableIteratorStream("CacheRepeatableStream");
    }

    @Test
    public void persistentMessageWithRepeatableIterator() throws Exception {
        this.doTestRepeatableIteratorStream("CachePersistentRepeatableStream");
    }

    private void doTestRepeatableIteratorStream(String flowName) {
        String streamKey = "stream";
        String counter = "counter";
        this.doMultiple(3, () -> {
            CoreEvent response = this.runObjectStreamingCacheFow(flowName);
            Map payload = (Map)response.getMessage().getPayload().getValue();
            CursorIteratorProvider provider = (CursorIteratorProvider)payload.get("stream");
            Iterator stream = (Iterator)provider.openCursor();
            LinkedList list = new LinkedList();
            stream.forEachRemaining(list::add);
            MatcherAssert.assertThat(list, (Matcher)Matchers.equalTo(STREAM_OBJECTS));
            MatcherAssert.assertThat(payload.get("counter"), (Matcher)Matchers.equalTo((Object)0));
        });
    }

    private CoreEvent runStreamingCachedFlow(String flowName) throws Exception {
        return ((FlowRunner)this.flowRunner(flowName).withVariable("stream", (Object)StreamingUtils.asCursorProvider((byte[])"test".getBytes()))).run();
    }

    private CoreEvent runObjectStreamingCacheFow(String flowName) throws Exception {
        return ((FlowRunner)this.flowRunner(flowName).withVariable("stream", (Object)StreamingUtils.asCursorProvider(STREAM_OBJECTS))).run();
    }

    private CoreEvent runCachedFlow(String flowName) throws Exception {
        return ((FlowRunner)new FlowRunner(this.registry, flowName).withPayload((Object)"test")).run();
    }

    public static class TestResponseGenerator
    implements ResponseGenerator {
        public CoreEvent create(CoreEvent request, CoreEvent cachedResponse) {
            return CoreEvent.builder((CoreEvent)request).message(Message.of((Object)CacheConfigTestCase.GENERATED_RESPONSE)).build();
        }
    }

    public static class TestMuleEventKeyGenerator
    implements MuleEventKeyGenerator {
        public String generateKey(CoreEvent event) {
            return CacheConfigTestCase.GENERATED_KEY;
        }
    }
}

