/*
 * (c) 2003-2019 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.cache.integration;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.MatcherAssert.assertThat;

import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.el.ExpressionManager;

import com.mulesoft.mule.test.cache.AbstractCacheFunctionalTestCase;

import javax.inject.Inject;

import org.junit.Test;

public class CacheExpressionKeyTestCase extends AbstractCacheFunctionalTestCase {

  @Inject
  ExpressionManager expressionManager;

  @Override
  protected String getConfigFile() {
    return "integration/expression-key-generation-coercion.xml";
  }

  @Test
  public void numberAsKey() throws Exception {
    TypedValue<Object> val1 = getCacheValue(10);
    TypedValue<Object> val2 = getCacheValue(10);
    assertThat(val1, is(val2));
  }

  @Test
  public void jsonStringAsKey() throws Exception {
    TypedValue evaluate = expressionManager.evaluate("output application/json --- 'jsonString'");
    TypedValue<Object> val1 = getCacheValue(evaluate);
    TypedValue<Object> val2 = getCacheValue(evaluate);
    assertThat(val1, is(val2));
  }

  @Test
  public void objectCantBeCoerced() throws Exception {
    TypedValue evaluate = expressionManager.evaluate("output application/json --- {}");
    TypedValue<Object> val1 = getCacheValue(evaluate);
    TypedValue<Object> val2 = getCacheValue(evaluate);
    assertThat(val1, is(not(val2)));
  }

  private TypedValue<Object> getCacheValue(Object cacheKey) throws Exception {
    return flowRunner("cache").withPayload(Math.random()).withVariable("key", cacheKey).run().getMessage().getPayload();
  }
}
