/*
 * (c) 2003-2019 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.cache.integration;

import static org.junit.Assert.assertEquals;

import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.message.Message;

import com.mulesoft.mule.test.cache.AbstractCacheFunctionalTestCase;

import java.io.Serializable;

import org.junit.Test;

public class CachedMutablePayloadTestCase extends AbstractCacheFunctionalTestCase {

  @Override
  protected String getConfigResources() {
    return "integration/cached-mutable-payload-config.xml";
  }

  @Test
  public void testName() throws Exception {
    FlowRunner runner = flowRunner("CacheRouterRequestResponse").withPayload("TEST");
    Message response1 = runner.run().getMessage();
    assertEquals(1, ((Counter) response1.getPayload().getValue()).getCount());

    runner.reset();
    Message response2 = runner.run().getMessage();
    assertEquals(1, ((Counter) response2.getPayload().getValue()).getCount());

    runner.reset();
    Message response3 = runner.run().getMessage();
    assertEquals(1, ((Counter) response3.getPayload().getValue()).getCount());
  }

  public static class Counter implements Serializable {

    private int count = 0;

    public Counter() {

    }

    public int getCount() {
      return count;
    }

    public void setCount(int count) {
      this.count = count;
    }

    public void inc() {
      count++;
    }
  }
}
