/*
 * (c) 2003-2019 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.cache.integration;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.junit.Assert.assertThat;
import org.mule.runtime.api.message.Message;

import com.mulesoft.mule.test.cache.AbstractCacheFunctionalTestCase;

import org.junit.Before;
import org.junit.Test;

public class InvalidateCacheTestCase extends AbstractCacheFunctionalTestCase {

  private String payload1;
  private String payload2;

  @Override
  protected String getConfigResources() {
    return "integration/invalidate-caching-strategy-config.xml";
  }

  @Before
  public void setUp() throws Exception {
    payload1 = "test1";
    payload2 = "test2";
  }

  @Test
  public void invalidatesCache() throws Exception {
    assertCachedResponse(payload1, 0);

    // Checks that resending message 1 gets the response from the cache
    assertCachedResponse(payload1, 0);
    assertCachedResponse(payload2, 1);

    flowRunner("invalidateFlow").withPayload(TEST_MESSAGE).run();

    // Checks that all keys were invalidated
    assertCachedResponse(payload1, 2);
    assertCachedResponse(payload2, 3);
  }

  @Test
  public void invalidatesKey() throws Exception {
    assertCachedResponse(payload1, 0);
    assertCachedResponse(payload2, 1);

    // Checks that resending message 1 gets the response from the cache
    assertCachedResponse(payload1, 0);

    flowRunner("invalidateItemFlow").withPayload(payload1).run();

    // Checks that only message 1 was invalidated
    assertCachedResponse(payload1, 2);
    assertCachedResponse(payload2, 1);
  }

  private void assertCachedResponse(String payload, int expectedCount) throws Exception {
    Message msg = flowRunner("cacheFlow").withPayload(payload).run().getMessage();
    assertThat(msg.getPayload().getValue(), equalTo(expectedCount));
  }
}
