/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.test.cache.integration;

import com.mulesoft.mule.test.cache.AbstractCacheFunctionalTestCase;
import java.io.InputStream;
import org.apache.commons.lang.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.func.CheckedRunnable;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.TestHttpClient;
import org.mule.tck.junit4.rule.DynamicPort;

public class CacheHttpInFlowTestCase
extends AbstractCacheFunctionalTestCase {
    @Rule
    public DynamicPort port = new DynamicPort("http.port");
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder((HttpService)this.getService(HttpService.class)).build();

    protected String getConfigFile() {
        return "integration/cache-http-in-flow-config.xml";
    }

    @Test
    public void cacheHttpInFlow() throws Exception {
        this.doMultiple(3, () -> {
            String response1 = this.request();
            junit.framework.Assert.assertNotNull((Object)response1);
            String response2 = this.request();
            junit.framework.Assert.assertNotNull((Object)response2);
            junit.framework.Assert.assertEquals((String)response1, (String)response2);
        });
    }

    @Test
    public void cacheHttpRequest() {
        String testPayload = RandomStringUtils.randomAlphabetic((int)20);
        this.doMultiple(3, () -> {
            HttpResponse response = this.httpClient.send(((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/request", this.port.getNumber())).method("POST").entity((HttpEntity)new ByteArrayHttpEntity(testPayload.getBytes()))).build());
            Assert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Matchers.equalTo((Object)testPayload));
        });
    }

    private void doMultiple(int count, CheckedRunnable task) {
        for (int i = 0; i < count; ++i) {
            task.run();
        }
    }

    private String request() throws Exception {
        return (String)((FlowRunner)this.flowRunner("http").withPayload((Object)"")).run().getMessage().getPayload().getValue();
    }
}

