/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.test.cache.integration;

import com.mulesoft.mule.test.cache.AbstractCacheFunctionalTestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.message.Message;

public class InvalidateCacheTestCase
extends AbstractCacheFunctionalTestCase {
    private String payload1;
    private String payload2;

    protected String getConfigResources() {
        return "integration/invalidate-caching-strategy-config.xml";
    }

    @Before
    public void setUp() throws Exception {
        this.payload1 = "test1";
        this.payload2 = "test2";
    }

    @Test
    public void invalidatesCache() throws Exception {
        this.assertCachedResponse(this.payload1, 0);
        this.assertCachedResponse(this.payload1, 0);
        this.assertCachedResponse(this.payload2, 1);
        ((FlowRunner)this.flowRunner("invalidateFlow").withPayload((Object)"Test Message")).run();
        this.assertCachedResponse(this.payload1, 2);
        this.assertCachedResponse(this.payload2, 3);
    }

    @Test
    public void invalidatesKey() throws Exception {
        this.assertCachedResponse(this.payload1, 0);
        this.assertCachedResponse(this.payload2, 1);
        this.assertCachedResponse(this.payload1, 0);
        ((FlowRunner)this.flowRunner("invalidateItemFlow").withPayload((Object)this.payload1)).run();
        this.assertCachedResponse(this.payload1, 2);
        this.assertCachedResponse(this.payload2, 1);
    }

    private void assertCachedResponse(String payload, int expectedCount) throws Exception {
        Message msg = ((FlowRunner)this.flowRunner("cacheFlow").withPayload((Object)payload)).run().getMessage();
        Assert.assertThat((Object)msg.getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)expectedCount));
    }
}

