/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.cache.integration;

import static com.mulesoft.test.allure.AllureConstants.CacheFeature.CACHE;
import static org.hamcrest.Matchers.nullValue;
import static org.junit.Assert.assertThat;
import static org.mule.tck.junit4.matcher.ErrorTypeMatcher.errorType;

import org.mule.functional.api.component.TestConnectorQueueHandler;

import com.mulesoft.mule.test.cache.AbstractCacheFunctionalTestCase;

import org.junit.Before;
import org.junit.Test;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;

@Feature(CACHE)
public class CacheErrorHandlingTestCase extends AbstractCacheFunctionalTestCase {

  private TestConnectorQueueHandler queueHandler;

  @Override
  protected String getConfigResources() {
    return "integration/cache-error-handling-config.xml";
  }

  @Before
  public void before() {
    queueHandler = new TestConnectorQueueHandler(registry);
  }

  @Test
  @Issue("EE-7619")
  public void errorInsideCache() throws Exception {
    flowRunner("errorInsideCache").runExpectingException(errorType("TEST", "EXPECTED"));

    assertThat(queueHandler.read("unknownHandled", RECEIVE_TIMEOUT), nullValue());
  }
}
