/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.cache.integration;

import static com.mulesoft.test.allure.AllureConstants.CacheFeature.CACHE;
import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;

import com.mulesoft.mule.test.cache.AbstractCacheFunctionalTestCase;

import org.junit.Test;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;

@Feature(CACHE)
public class CacheEventSerializationTestCase extends AbstractCacheFunctionalTestCase {

  @Override
  protected String getConfigResources() {
    return "integration/cache-event-serialization-config.xml";
  }

  @Test
  @Issue("EE-7272")
  @Description("Even if the event contains a non-serializable variable, the message is cached and the following execution is a cache hit")
  public void notSerializableVar() throws Exception {
    assertThat(flowRunner("notSerializableVar").run().getMessage().getPayload().getValue(), is(0));

    assertThat("Previous execution not cached", flowRunner("notSerializableVar").run().getMessage().getPayload().getValue(),
               is(0));
  }
}
