/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.cache.integration;

import static com.mulesoft.test.allure.AllureConstants.CacheFeature.CACHE;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.nullValue;
import static org.junit.Assert.assertThat;

import org.mule.runtime.core.api.util.func.CheckedRunnable;
import org.mule.tck.junit4.rule.DynamicPort;

import com.mulesoft.mule.test.cache.AbstractCacheFunctionalTestCase;

import org.junit.Rule;
import org.junit.Test;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;

@Feature(CACHE)
public class CacheHttpInRoutersTestCase extends AbstractCacheFunctionalTestCase {

  @Rule
  public DynamicPort port = new DynamicPort("http.port");

  @Override
  protected String getConfigFile() {
    return "integration/cache-http-in-routers-config.xml";
  }

  @Test
  @Issue("EE-7306")
  public void cacheHttp() throws Exception {
    doMultiple(3, () -> {
      String response1 = request("http", "hello");
      assertThat(response1, not(nullValue()));

      String response2 = request("http", "hello");
      assertThat(response2, equalTo(response1));

      String response3 = request("http", "goodbye");
      assertThat(response3, not(nullValue()));
    });
  }

  @Test
  @Issue("EE-7306")
  public void cacheHttpParallelForEach() throws Exception {
    doMultiple(3, () -> {
      String response1 = request("httpParallelForeach", "hello");
      assertThat(response1, not(nullValue()));

      String response2 = request("httpParallelForeach", "hello");
      assertThat(response2, equalTo(response1));

      String response3 = request("httpParallelForeach", "goodbye");
      assertThat(response3, not(nullValue()));
    });
  }

  @Test
  @Issue("EE-7306")
  public void cacheHttpUntilSuccesful() throws Exception {
    doMultiple(3, () -> {
      String response1 = request("httpUntilSuccessful", "hello");
      assertThat(response1, not(nullValue()));

      String response2 = request("httpUntilSuccessful", "hello");
      assertThat(response2, equalTo(response1));

      String response3 = request("httpUntilSuccessful", "goodbye");
      assertThat(response3, not(nullValue()));
    });
  }

  @Test
  public void cacheHttpTry() throws Exception {
    doMultiple(3, () -> {
      String response1 = request("httpTry", "hello");
      assertThat(response1, not(nullValue()));

      String response2 = request("httpTry", "hello");
      assertThat(response2, equalTo(response1));

      String response3 = request("httpTry", "goodbye");
      assertThat(response3, not(nullValue()));
    });
  }

  @Test
  public void cacheHttpTry2() throws Exception {
    doMultiple(3, () -> {
      String response1 = request("httpTry2", "hello");
      assertThat(response1, not(nullValue()));

      String response2 = request("httpTry2", "hello");
      assertThat(response2, equalTo(response1));

      String response3 = request("httpTry2", "goodbye");
      assertThat(response3, not(nullValue()));
    });
  }

  private void doMultiple(int count, CheckedRunnable task) {
    for (int i = 0; i < count; i++) {
      task.run();
    }
  }

  private String request(String flowName, String payload) throws Exception {
    return (String) flowRunner(flowName).withPayload(payload).run().getMessage().getPayload().getValue();
  }

  // TODO MULE-17934 remove this
  @Override
  protected boolean isGracefulShutdown() {
    return true;
  }
}
