/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.cache.integration;

import static com.mulesoft.test.allure.AllureConstants.CacheFeature.CACHE;
import static org.apache.commons.lang.RandomStringUtils.randomAlphabetic;
import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.nullValue;
import static org.junit.Assert.assertThat;

import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.api.util.func.CheckedRunnable;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.TestHttpClient;
import org.mule.tck.junit4.rule.DynamicPort;

import com.mulesoft.mule.test.cache.AbstractCacheFunctionalTestCase;

import org.junit.Rule;
import org.junit.Test;

import io.qameta.allure.Feature;

@Feature(CACHE)
public class CacheHttpInFlowTestCase extends AbstractCacheFunctionalTestCase {

  @Rule
  public DynamicPort port = new DynamicPort("http.port");

  @Rule
  public TestHttpClient httpClient = new TestHttpClient.Builder(getService(HttpService.class)).build();

  @Override
  protected String getConfigFile() {
    return "integration/cache-http-in-flow-config.xml";
  }

  @Test
  public void cacheHttpInFlow() throws Exception {
    doMultiple(3, () -> {
      String response1 = request("hello");
      assertThat(response1, not(nullValue()));

      String response2 = request("hello");
      assertThat(response2, equalTo(response1));

      String response3 = request("goodbye");
      assertThat(response3, not(nullValue()));
    });
  }

  @Test
  public void cacheHttpRequest() {
    final String testPayload = randomAlphabetic(20);

    doMultiple(3, () -> {
      HttpResponse response = httpClient.send(HttpRequest.builder()
          .uri(String.format("http://localhost:%d/request", port.getNumber()))
          .method("POST")
          .entity(new ByteArrayHttpEntity(testPayload.getBytes()))
          .build());

      assertThat(IOUtils.toString(response.getEntity().getContent()), equalTo(testPayload));
    });
  }

  private void doMultiple(int count, CheckedRunnable task) {
    for (int i = 0; i < count; i++) {
      task.run();
    }
  }

  private String request(String payload) throws Exception {
    return (String) flowRunner("http").withPayload(payload).run().getMessage().getPayload().getValue();
  }

  // TODO MULE-17934 remove this
  @Override
  protected boolean isGracefulShutdown() {
    return true;
  }
}
