/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.test.cache.integration;

import com.mulesoft.mule.test.cache.AbstractCacheFunctionalTestCase;
import io.qameta.allure.Feature;
import java.io.Serializable;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.SimpleMemoryObjectStore;

@Feature(value="Cache scope")
public class CacheNonBlockingInFlowTestCase
extends AbstractCacheFunctionalTestCase {
    protected String getConfigFile() {
        return "integration/cache-nonblocking-in-flow-config.xml";
    }

    @Test
    public void usingCacheSynchronizeOnNonBlockingFlowTest() throws Exception {
        this.doTestCacheNonBlockingFlow("cacheSynchronizeOnNonBlockingFlow");
    }

    @Test
    public void usingCacheNonSynchronizeOnNonBlockingFlowTest() throws Exception {
        this.doTestCacheNonBlockingFlow("cacheNonSynchronizeOnNonBlockingFlow");
    }

    private void doTestCacheNonBlockingFlow(String flowName) throws Exception {
        Message response1 = ((FlowRunner)((FlowRunner)this.flowRunner(flowName).withVariable("requestId", (Object)"1")).withPayload((Object)"test")).run().getMessage();
        junit.framework.Assert.assertNotNull((Object)response1);
        Message response2 = ((FlowRunner)((FlowRunner)this.flowRunner(flowName).withVariable("requestId", (Object)"1")).withPayload((Object)"test")).run().getMessage();
        junit.framework.Assert.assertNotNull((Object)response2);
        Assert.assertThat((Object)response2.getPayload().getValue(), (Matcher)CoreMatchers.equalTo((Object)response1.getPayload().getValue()));
    }

    public static class CustomObjectStore
    extends SimpleMemoryObjectStore<Serializable> {
        @Inject
        private ObjectSerializer objectSerializer;

        protected void doStore(String id, Serializable value) throws ObjectStoreException {
            byte[] serialized = this.objectSerializer.getInternalProtocol().serialize((Object)value);
            super.doStore(id, (Serializable)serialized);
        }

        protected Serializable doRetrieve(String key) throws ObjectStoreException {
            Serializable retrieved = super.doRetrieve(key);
            if (retrieved != null) {
                retrieved = (Serializable)this.objectSerializer.getInternalProtocol().deserialize((byte[])retrieved);
            }
            return retrieved;
        }
    }
}

