/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.test.cache;

import com.mulesoft.mule.test.cache.AbstractCacheFunctionalTestCase;
import io.qameta.allure.Feature;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;

@Feature(value="Cache scope")
public class NonBlockingCacheTestCase
extends AbstractCacheFunctionalTestCase {
    private static CountDownLatch enterLatch;
    private static CountDownLatch exitLatch;
    private static List<String> threadNames;
    @Inject
    private SchedulerService schedulerService;
    private Scheduler cpuLightScheduler;
    private Scheduler testScheduler;

    protected String getConfigFile() {
        return "non-blocking-cache-test-config.xml";
    }

    @Before
    public void before() {
        enterLatch = new CountDownLatch(1);
        exitLatch = new CountDownLatch(1);
        threadNames = new ArrayList<String>();
        this.cpuLightScheduler = this.schedulerService.cpuLightScheduler();
        this.testScheduler = this.schedulerService.customScheduler(SchedulerConfig.config().withName("test").withMaxConcurrentTasks(2 + Runtime.getRuntime().availableProcessors() * 2));
    }

    @After
    public void after() {
        this.testScheduler.stop();
        this.cpuLightScheduler.stop();
    }

    @Test
    public void synchronizedCache() throws Exception {
        ((FlowRunner)this.flowRunner("synchronizedCache").withPayload((Object)"Test Message")).run();
        ((FlowRunner)this.flowRunner("synchronizedCache").withPayload((Object)"Test Message")).run();
    }

    @Test
    public void cacheSynchronizeFreesCpuLight() throws Exception {
        this.testScheduler.submit(() -> ((FlowRunner)this.flowRunner("cacheSynchronizeFreesCpuLight").withPayload((Object)"Test Message")).run());
        enterLatch.await();
        for (int i = 0; i < Runtime.getRuntime().availableProcessors() * 2 - 1; ++i) {
            this.testScheduler.submit(() -> ((FlowRunner)this.flowRunner("cacheSynchronizeFreesCpuLight").withPayload((Object)"Test Message")).run());
        }
        Thread.sleep(2000L);
        this.cpuLightScheduler.submit(() -> {}).get(5L, TimeUnit.SECONDS);
    }

    @Test
    public void unsynchronizedCache() throws Exception {
        ((FlowRunner)this.flowRunner("unsynchronizedCache").withPayload((Object)"Test Message")).run();
        ((FlowRunner)this.flowRunner("unsynchronizedCache").withPayload((Object)"Test Message")).run();
    }

    public static final class LatchedProcessor
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            enterLatch.countDown();
            threadNames.add(Thread.currentThread().getName());
            try {
                exitLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DefaultMuleException((Throwable)e);
            }
            return event;
        }
    }
}

