/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.cache.config;

import static com.mulesoft.test.allure.AllureConstants.CacheFeature.CACHE;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.nullValue;
import static reactor.core.publisher.Flux.from;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;

import com.mulesoft.mule.runtime.cache.api.CachingStrategy;
import com.mulesoft.mule.test.cache.AbstractCacheFunctionalTestCase;

import org.junit.Test;

import io.qameta.allure.Feature;

@Feature(CACHE)
public class CacheStrategyConfigTestCase extends AbstractCacheFunctionalTestCase {

  @Override
  protected String getConfigFile() {
    return "config/cache-strategy-config.xml";
  }

  @Test
  public void appWithCustomCachingStrategyStartsCorrectly() throws Exception {
    assertThat(flowRunner("processWithCache").run(), not(nullValue()));
  }

  public static class TestCachingStrategy implements CachingStrategy {

    @Override
    public CoreEvent process(CoreEvent request, Processor messageProcessor) throws MuleException {
      throw new UnsupportedOperationException();
    }

    @Override
    public ReactiveProcessor transformProcessor(Processor processor) {
      return publisher -> from(publisher).transform(processor);
    }
  }

}
