/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.cache.integration;

import static com.mulesoft.test.allure.AllureConstants.CacheFeature.CACHE;

import org.mule.runtime.api.metadata.TypedValue;
import org.mule.tck.junit4.rule.DynamicPort;

import com.mulesoft.mule.test.cache.AbstractCacheFunctionalTestCase;

import org.junit.Rule;
import org.junit.Test;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;

@Feature(CACHE)
public class CacheExpressionKeyTestErrorCase extends AbstractCacheFunctionalTestCase {

  @Rule
  public DynamicPort port = new DynamicPort("http.port");

  @Override
  protected String getConfigFile() {
    return "integration/expression-key-generation-error-config.xml";
  }

  @Test
  @Issue("EE-7306")
  public void nullKey() throws Exception {
    getCacheValue();
    getCacheValue();
  }

  private TypedValue<Object> getCacheValue() throws Exception {
    return flowRunner("cache").withPayload(Math.random()).run().getMessage().getPayload();
  }
}
