/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.cache.integration;

import static com.mulesoft.test.allure.AllureConstants.CacheFeature.CACHE;
import static java.util.concurrent.TimeUnit.MILLISECONDS;
import static org.hamcrest.Matchers.nullValue;
import static org.junit.Assert.assertThat;
import static org.mule.tck.junit4.matcher.ErrorTypeMatcher.errorType;

import org.mule.tests.api.TestQueueManager;

import com.mulesoft.mule.test.cache.AbstractCacheFunctionalTestCase;

import javax.inject.Inject;

import org.junit.Test;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;

@Feature(CACHE)
public class CacheErrorHandlingTestCase extends AbstractCacheFunctionalTestCase {

  @Inject
  private TestQueueManager queueManager;

  @Override
  protected String getConfigResources() {
    return "integration/cache-error-handling-config.xml";
  }

  @Test
  @Issue("EE-7619")
  public void errorInsideCache() throws Exception {
    flowRunner("errorInsideCache").runExpectingException(errorType("APP", "EXPECTED"));

    assertThat(queueManager.read("unknownHandled", RECEIVE_TIMEOUT, MILLISECONDS), nullValue());
  }
}
