/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.test.cache.config;

import com.mulesoft.mule.runtime.cache.api.CachingStrategy;
import com.mulesoft.mule.test.cache.AbstractCacheFunctionalTestCase;
import io.qameta.allure.Feature;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Feature(value="Cache scope")
public class CacheStrategyConfigTestCase
extends AbstractCacheFunctionalTestCase {
    protected String getConfigFile() {
        return "config/cache-strategy-config.xml";
    }

    @Test
    public void appWithCustomCachingStrategyStartsCorrectly() throws Exception {
        MatcherAssert.assertThat((Object)this.flowRunner("processWithCache").run(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
    }

    public static class TestCachingStrategy
    implements CachingStrategy {
        public CoreEvent process(CoreEvent request, Processor messageProcessor) throws MuleException {
            throw new UnsupportedOperationException();
        }

        public ReactiveProcessor transformProcessor(Processor processor) {
            return publisher -> Flux.from((Publisher)publisher).transform((Function)processor);
        }
    }
}

