/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.test.cache.integration;

import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.message.Message;
import org.mule.tests.api.TestQueueManager;

public abstract class AbstractCachingStrategyTestCase
extends MuleArtifactFunctionalTestCase {
    @Inject
    private TestQueueManager queueManager;

    protected String[] getConfigFiles() {
        return new String[]{"integration/message-caching-config.xml", this.getCachingStrategyConfigResource()};
    }

    protected abstract String getCachingStrategyConfigResource();

    @Test
    public void testCachesMessageRequestResponse() throws Exception {
        Message msg = ((FlowRunner)this.flowRunner("CacheRouterRequestResponse").withPayload((Object)"test1")).run().getMessage();
        Assert.assertEquals((Object)"0 Processed", (Object)msg.getPayload().getValue());
        msg = ((FlowRunner)this.flowRunner("CacheRouterRequestResponse").withPayload((Object)"test2")).run().getMessage();
        Assert.assertEquals((Object)"1 Processed", (Object)msg.getPayload().getValue());
        msg = ((FlowRunner)this.flowRunner("CacheRouterRequestResponse").withPayload((Object)"test1")).run().getMessage();
        Assert.assertEquals((Object)"0 Processed", (Object)msg.getPayload().getValue());
    }

    @Test
    public void testCachesMessageOneWay() throws Exception {
        ((FlowRunner)this.flowRunner("CacheRouterOneWay").withPayload((Object)"test3")).run();
        Message msg = this.queueManager.read("output", 5000L, TimeUnit.MILLISECONDS).getMessage();
        Assert.assertEquals((Object)"0 Processed", (Object)msg.getPayload().getValue());
        ((FlowRunner)this.flowRunner("CacheRouterOneWay").withPayload((Object)"test4")).run();
        msg = this.queueManager.read("output", 5000L, TimeUnit.MILLISECONDS).getMessage();
        Assert.assertEquals((Object)"1 Processed", (Object)msg.getPayload().getValue());
        ((FlowRunner)this.flowRunner("CacheRouterOneWay").withPayload((Object)"test3")).run();
        msg = this.queueManager.read("output", 5000L, TimeUnit.MILLISECONDS).getMessage();
        Assert.assertEquals((Object)"0 Processed", (Object)msg.getPayload().getValue());
    }
}

