/*
 * (c) 2003-2023 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.cache;

import static org.mule.test.allure.AllureConstants.Logging.LOGGING;
import static org.mule.test.allure.AllureConstants.Logging.LoggingStory.LOG_FORMAT;
import static com.mulesoft.test.allure.AllureConstants.CacheFeature.CACHE;
import static java.lang.String.format;
import static java.util.stream.Collectors.toList;
import static org.hamcrest.Matchers.containsInAnyOrder;
import static org.hamcrest.Matchers.hasSize;
import static org.junit.Assert.assertThat;

import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.scheduler.SchedulerView;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import org.junit.Test;

import javax.inject.Inject;
import java.util.List;

@Features({@Feature(CACHE), @Feature(LOGGING)})
@Story(LOG_FORMAT)
public class CacheSchedulerNameTestCase extends AbstractCacheFunctionalTestCase {

  private static final String SCHEDULER_NAME_FORMAT =
      "[CacheSchedulerNameTestCase#cachingStrategySchedulerName].%s_[cachingStrategy]";

  @Inject
  private SchedulerService schedulerService;

  @Override
  protected String getConfigFile() {
    return "config/cache-schedulers-names.xml";
  }

  @Test
  @Description("Scheduler used in the caching strategy should have proper name")
  @Issue("W-11818064")
  public void cachingStrategySchedulerName() {
    List<String> names = schedulerService.getSchedulers().stream().map(SchedulerView::getName)
        .filter(name -> name.contains("_[cachingStrategy]")).map(name -> name.split(" @")[0]).collect(toList());
    assertThat(names, hasSize(2));
    assertThat(names, containsInAnyOrder(format(SCHEDULER_NAME_FORMAT, "flow1/processors/0"),
                                         format(SCHEDULER_NAME_FORMAT, "flow2/processors/1")));
  }
}
