/*
 * (c) 2003-2023 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.cache.integration;

import static java.util.concurrent.TimeUnit.MILLISECONDS;
import static org.junit.Assert.assertEquals;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.message.Message;
import org.mule.tests.api.TestQueueManager;

import com.mulesoft.mule.runtime.cache.api.CachingStrategy;

import javax.inject.Inject;

import org.junit.Test;

/**
 * Defines a contract test for {@link CachingStrategy}.
 * <p/>
 * Subclasses must provide a configuration of a cachingStrategy bean
 */
public abstract class AbstractCachingStrategyTestCase extends MuleArtifactFunctionalTestCase {

  @Inject
  private TestQueueManager queueManager;

  @Override
  protected String[] getConfigFiles() {
    return new String[] {"integration/message-caching-config.xml", getCachingStrategyConfigResource()};
  }

  /**
   * @return comma separated list of the mule config file path's containing the declaration of the caching strategy bean and any
   *         extra needed configuration.
   */
  protected abstract String getCachingStrategyConfigResource();

  @Test
  public void testCachesMessageRequestResponse() throws Exception {
    Message msg = flowRunner("CacheRouterRequestResponse").withPayload("test1").run().getMessage();
    assertEquals("0 Processed", msg.getPayload().getValue());

    msg = flowRunner("CacheRouterRequestResponse").withPayload("test2").run().getMessage();
    assertEquals("1 Processed", msg.getPayload().getValue());

    // Checks that resending message 1 gets the response form the cache
    msg = flowRunner("CacheRouterRequestResponse").withPayload("test1").run().getMessage();
    assertEquals("0 Processed", msg.getPayload().getValue());
  }

  @Test
  public void testCachesMessageOneWay() throws Exception {
    flowRunner("CacheRouterOneWay").withPayload("test3").run();
    Message msg = queueManager.read("output", 5000, MILLISECONDS).getMessage();
    assertEquals("0 Processed", msg.getPayload().getValue());

    flowRunner("CacheRouterOneWay").withPayload("test4").run();
    msg = queueManager.read("output", 5000, MILLISECONDS).getMessage();
    assertEquals("1 Processed", msg.getPayload().getValue());

    // Checks that resending message 1 gets the response form the cache
    flowRunner("CacheRouterOneWay").withPayload("test3").run();
    msg = queueManager.read("output", 5000, MILLISECONDS).getMessage();
    assertEquals("0 Processed", msg.getPayload().getValue());
  }
}
