/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.test.cache;

import com.mulesoft.mule.test.cache.AbstractCacheFunctionalTestCase;
import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.scheduler.SchedulerView;

@Features(value={@Feature(value="Cache scope"), @Feature(value="Logging")})
@Story(value="Logging Format")
public class CacheSchedulerNameTestCase
extends AbstractCacheFunctionalTestCase {
    private static final String SCHEDULER_NAME_FORMAT = "[CacheSchedulerNameTestCase#cachingStrategySchedulerName].%s_[cachingStrategy]";
    @Inject
    private SchedulerService schedulerService;

    protected String getConfigFile() {
        return "config/cache-schedulers-names.xml";
    }

    @Test
    @Description(value="Scheduler used in the caching strategy should have proper name")
    @Issue(value="W-11818064")
    public void cachingStrategySchedulerName() {
        List names = this.schedulerService.getSchedulers().stream().map(SchedulerView::getName).filter(name -> name.contains("_[cachingStrategy]")).map(name -> name.split(" @")[0]).collect(Collectors.toList());
        Assert.assertThat(names, (Matcher)Matchers.hasSize((int)2));
        Assert.assertThat(names, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{String.format(SCHEDULER_NAME_FORMAT, "flow1/processors/0"), String.format(SCHEDULER_NAME_FORMAT, "flow2/processors/1")}));
    }
}

