/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.test.cache.integration;

import com.mulesoft.mule.test.cache.integration.LatchedIncreasingNumberProcessor;
import io.qameta.allure.Issue;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.functional.junit4.matchers.MessageMatchers;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.tck.junit4.matcher.EventMatcher;
import org.mule.tck.probe.PollingProber;
import org.mule.tests.api.TestQueueManager;

public abstract class AbstractCachingStrategyTestCase
extends MuleArtifactFunctionalTestCase {
    @Inject
    private TestQueueManager queueManager;

    protected String[] getConfigFiles() {
        return new String[]{"integration/message-caching-config.xml", this.getCachingStrategyConfigResource()};
    }

    protected abstract String getCachingStrategyConfigResource();

    @Test
    public void testCachesMessageRequestResponse() throws Exception {
        Message msg = ((FlowRunner)this.flowRunner("CacheRouterRequestResponse").withPayload((Object)"test1")).run().getMessage();
        Assert.assertEquals((Object)"0 Processed", (Object)msg.getPayload().getValue());
        msg = ((FlowRunner)this.flowRunner("CacheRouterRequestResponse").withPayload((Object)"test2")).run().getMessage();
        Assert.assertEquals((Object)"1 Processed", (Object)msg.getPayload().getValue());
        msg = ((FlowRunner)this.flowRunner("CacheRouterRequestResponse").withPayload((Object)"test1")).run().getMessage();
        Assert.assertEquals((Object)"0 Processed", (Object)msg.getPayload().getValue());
    }

    @Test
    public void testCachesMessageOneWay() throws Exception {
        ((FlowRunner)this.flowRunner("CacheRouterOneWay").withPayload((Object)"test3")).run();
        Message msg = this.queueManager.read("output", 5000L, TimeUnit.MILLISECONDS).getMessage();
        Assert.assertEquals((Object)"0 Processed", (Object)msg.getPayload().getValue());
        ((FlowRunner)this.flowRunner("CacheRouterOneWay").withPayload((Object)"test4")).run();
        msg = this.queueManager.read("output", 5000L, TimeUnit.MILLISECONDS).getMessage();
        Assert.assertEquals((Object)"1 Processed", (Object)msg.getPayload().getValue());
        ((FlowRunner)this.flowRunner("CacheRouterOneWay").withPayload((Object)"test3")).run();
        msg = this.queueManager.read("output", 5000L, TimeUnit.MILLISECONDS).getMessage();
        Assert.assertEquals((Object)"0 Processed", (Object)msg.getPayload().getValue());
    }

    @Test
    @Issue(value="W-14604517")
    public void testCacheIdempotencyWithConcurrentEvents() throws Exception {
        int i;
        int numConcurrentEvents = 20;
        FlowRunner flowRunner = (FlowRunner)this.flowRunner("CacheLatched").withPayload((Object)"test");
        ExecutorService executorService = Executors.newFixedThreadPool(numConcurrentEvents);
        ArrayList<Future<CoreEvent>> results = new ArrayList<Future<CoreEvent>>(numConcurrentEvents);
        for (i = 0; i < numConcurrentEvents; ++i) {
            results.add(executorService.submit(() -> ((FlowRunner)flowRunner).run()));
        }
        PollingProber.check((long)5000L, (long)100L, () -> LatchedIncreasingNumberProcessor.getCount() > 0);
        Thread.sleep(500L);
        LatchedIncreasingNumberProcessor.release();
        for (i = 0; i < numConcurrentEvents; ++i) {
            MatcherAssert.assertThat((Object)((CoreEvent)((Future)results.get(i)).get()), (Matcher)EventMatcher.hasMessage((Matcher)MessageMatchers.hasPayload((Matcher)Is.is((Object)"0"))));
        }
    }
}

