/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.test.cache.integration;

import com.mulesoft.mule.test.cache.AbstractCacheFunctionalTestCase;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.api.util.func.CheckedRunnable;
import org.mule.tck.junit4.rule.DynamicPort;

@Feature(value="Cache scope")
public class CacheHttpInRoutersTestCase
extends AbstractCacheFunctionalTestCase {
    @Rule
    public DynamicPort port = new DynamicPort("http.port");

    protected String getConfigFile() {
        return "integration/cache-http-in-routers-config.xml";
    }

    @Test
    @Issue(value="EE-7306")
    public void cacheHttp() throws Exception {
        this.doMultiple(3, () -> {
            String response1 = this.request("http", "hello");
            Assert.assertThat((Object)response1, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
            String response2 = this.request("http", "hello");
            Assert.assertThat((Object)response2, (Matcher)Matchers.equalTo((Object)response1));
            String response3 = this.request("http", "goodbye");
            Assert.assertThat((Object)response3, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        });
    }

    @Test
    @Issue(value="EE-7306")
    public void cacheHttpParallelForEach() throws Exception {
        this.doMultiple(3, () -> {
            String response1 = this.request("httpParallelForeach", "hello");
            Assert.assertThat((Object)response1, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
            String response2 = this.request("httpParallelForeach", "hello");
            Assert.assertThat((Object)response2, (Matcher)Matchers.equalTo((Object)response1));
            String response3 = this.request("httpParallelForeach", "goodbye");
            Assert.assertThat((Object)response3, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        });
    }

    @Test
    @Issue(value="EE-7306")
    public void cacheHttpUntilSuccesful() throws Exception {
        this.doMultiple(3, () -> {
            String response1 = this.request("httpUntilSuccessful", "hello");
            Assert.assertThat((Object)response1, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
            String response2 = this.request("httpUntilSuccessful", "hello");
            Assert.assertThat((Object)response2, (Matcher)Matchers.equalTo((Object)response1));
            String response3 = this.request("httpUntilSuccessful", "goodbye");
            Assert.assertThat((Object)response3, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        });
    }

    @Test
    public void cacheHttpTry() throws Exception {
        this.doMultiple(3, () -> {
            String response1 = this.request("httpTry", "hello");
            Assert.assertThat((Object)response1, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
            String response2 = this.request("httpTry", "hello");
            Assert.assertThat((Object)response2, (Matcher)Matchers.equalTo((Object)response1));
            String response3 = this.request("httpTry", "goodbye");
            Assert.assertThat((Object)response3, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        });
    }

    @Test
    public void cacheHttpTry2() throws Exception {
        this.doMultiple(3, () -> {
            String response1 = this.request("httpTry2", "hello");
            Assert.assertThat((Object)response1, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
            String response2 = this.request("httpTry2", "hello");
            Assert.assertThat((Object)response2, (Matcher)Matchers.equalTo((Object)response1));
            String response3 = this.request("httpTry2", "goodbye");
            Assert.assertThat((Object)response3, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        });
    }

    private void doMultiple(int count, CheckedRunnable task) {
        for (int i = 0; i < count; ++i) {
            task.run();
        }
    }

    private String request(String flowName, String payload) throws Exception {
        return (String)((FlowRunner)this.flowRunner(flowName).withPayload((Object)payload)).run().getMessage().getPayload().getValue();
    }

    protected boolean isGracefulShutdown() {
        return true;
    }
}

