/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.test.cache.integration;

import java.util.concurrent.atomic.AtomicInteger;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.privileged.exception.EventProcessingException;

public class LatchedIncreasingNumberProcessor
implements Processor {
    private static final Latch WAIT_AFTER_PROCESSING = new Latch();
    private static final AtomicInteger CURRENT_COUNT = new AtomicInteger();

    public static void release() {
        WAIT_AFTER_PROCESSING.release();
    }

    public static int getCount() {
        return CURRENT_COUNT.get();
    }

    public CoreEvent process(CoreEvent event) throws MuleException {
        CoreEvent result = CoreEvent.builder((CoreEvent)event).message(Message.builder((Message)event.getMessage()).value((Object)CURRENT_COUNT.getAndIncrement()).build()).build();
        try {
            WAIT_AFTER_PROCESSING.await();
        }
        catch (InterruptedException e) {
            throw new EventProcessingException(event, (Throwable)e);
        }
        return result;
    }
}

