/*
 * (c) 2003-2023 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.domain.integration;

import static java.lang.String.format;
import static java.nio.charset.StandardCharsets.UTF_8;
import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;
import static org.mule.runtime.http.api.HttpConstants.Method.POST;
import static org.mule.tck.junit4.AbstractMuleContextTestCase.RECEIVE_TIMEOUT;

import io.qameta.allure.Issue;
import org.mule.functional.junit4.DomainFunctionalTestCase;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.TestHttpClient;
import org.mule.tck.junit4.rule.DynamicPort;

import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

public class HttpShareConnectorCommunicationTestCase extends DomainFunctionalTestCase {

  public static final String CLIENT_APP = "client-app";
  public static final String SERVER_APP = "server-app";

  @Rule
  public DynamicPort httpPort = new DynamicPort("httpPort");
  @Rule
  public DynamicPort httpsPort = new DynamicPort("httpsPort");
  @Rule
  public TestHttpClient httpClient = new TestHttpClient.Builder().build();

  @Override
  protected String getDomainConfig() {
    return "domain-config/http-https-shared-connectors.xml";
  }

  @Override
  public ApplicationConfig[] getConfigResources() {
    return new ApplicationConfig[] {new ApplicationConfig(SERVER_APP, new String[] {"http-server-app.xml"}),
        new ApplicationConfig(CLIENT_APP, new String[] {"http-client-app.xml"})};
  }

  @Test
  @Ignore("MULE-4808")
  @Issue("MULE-4808")
  public void messageIsProcessedCorrectly() throws Exception {
    String messageContent = "test";

    HttpRequest request = HttpRequest.builder().uri(format("http://localhost:%s/publicService", httpPort.getNumber()))
        .entity(new ByteArrayHttpEntity(messageContent.getBytes()))
        .method(POST).build();

    HttpResponse response = httpClient.send(request, RECEIVE_TIMEOUT, false, null);

    String payload =
        org.apache.commons.io.IOUtils.toString(response.getEntity().getContent(), UTF_8);
    assertThat(payload, is(messageContent));
  }
}
