/*
 * (c) 2003-2023 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.domain.service.scheduler;

import static com.google.common.collect.ImmutableSet.of;
import static java.util.Collections.singletonMap;
import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;
import static org.mule.runtime.core.api.config.MuleProperties.OBJECT_CLASSLOADER_REPOSITORY;

import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;

import org.mule.functional.junit4.FunctionalTestCase;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfigFactory;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.core.internal.config.preferred.PreferredObjectSelector;
import org.mule.runtime.core.internal.context.MuleContextWithRegistry;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;

import com.mulesoft.mule.runtime.core.api.extension.MuleEeExtensionModelProvider;

public abstract class AbstractCustomSchedulerConfigTestCase extends FunctionalTestCase {

  protected SchedulerPoolsConfigFactory getSchedulerPoolsConfigFactory() {
    return new PreferredObjectSelector<SchedulerPoolsConfigFactory>()
        .select(((MuleContextWithRegistry) muleContext).getRegistry().lookupObjects(SchedulerPoolsConfigFactory.class)
            .iterator());
  }

  @Override
  protected Map<String, Object> getStartUpRegistryObjects() {
    // Verify inconsistency between mockito and bytebuddy for using a mock here
    return singletonMap(OBJECT_CLASSLOADER_REPOSITORY, new ClassLoaderRepository() {

      @Override
      public Optional<String> getId(ClassLoader classLoader) {
        return null;
      }

      @Override
      public Optional<ClassLoader> find(String classLoaderId) {
        return null;
      }
    });
  }

  protected void assertEmpty(OptionalInt value) {
    assertThat(value.isPresent(), is(false));
  }

  protected void assertEmpty(OptionalLong value) {
    assertThat(value.isPresent(), is(false));
  }

  @Override
  protected Set<ExtensionModel> getExtensionModels() {
    return of(MuleExtensionModelProvider.getExtensionModel(), MuleEeExtensionModelProvider.getExtensionModel());
  }
}
