/*
 * (c) 2003-2023 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.domain.service.scheduler;

import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;
import static org.mule.runtime.api.scheduler.SchedulerPoolStrategy.DEDICATED;
import static org.mule.test.allure.AllureConstants.SchedulerServiceFeature.SCHEDULER_SERVICE;

import org.mule.runtime.api.scheduler.SchedulerPoolsConfig;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfigFactory;

import io.qameta.allure.Feature;
import org.junit.Test;

@Feature(SCHEDULER_SERVICE)
public class SchedulerCustomDedicatedPoolTestCase extends AbstractCustomSchedulerConfigTestCase {

  @Override
  protected String getConfigFile() {
    return "service/scheduler/scheduler-custom-dedicated-pool-app.xml";
  }

  @Test
  public void customDedicatedPoolConfig() {
    final SchedulerPoolsConfigFactory factory = getSchedulerPoolsConfigFactory();

    SchedulerPoolsConfig config = factory.getConfig().get();

    assertThat(config.getSchedulerPoolStrategy(), is(DEDICATED));

    assertEmpty(config.getUberCorePoolSize());
    assertEmpty(config.getUberMaxPoolSize());
    assertEmpty(config.getUberQueueSize());
    assertEmpty(config.getUberKeepAlive());

    assertThat(config.getCpuIntensivePoolSize().getAsInt(), is(4));
    assertThat(config.getCpuIntensiveQueueSize().getAsInt(), is(2048));

    assertThat(config.getCpuLightPoolSize().getAsInt(), is(2));
    assertThat(config.getCpuLightQueueSize().getAsInt(), is(1024));

    assertThat(config.getIoCorePoolSize().getAsInt(), is(1));
    assertThat(config.getIoMaxPoolSize().getAsInt(), is(2));
    assertThat(config.getIoQueueSize().getAsInt(), is(0));
    assertThat(config.getIoKeepAlive().getAsLong(), is(30000L));
  }
}
