/*
 * (c) 2003-2023 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.domain.service.scheduler;

import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;
import static org.mule.runtime.api.scheduler.SchedulerPoolStrategy.UBER;
import static org.mule.test.allure.AllureConstants.SchedulerServiceFeature.SCHEDULER_SERVICE;

import org.mule.runtime.api.scheduler.SchedulerPoolsConfig;
import org.mule.runtime.api.scheduler.SchedulerPoolsConfigFactory;

import io.qameta.allure.Feature;
import org.junit.Test;

@Feature(SCHEDULER_SERVICE)
public class SchedulerCustomUberPoolTestCase extends AbstractCustomSchedulerConfigTestCase {

  @Override
  protected String getConfigFile() {
    return "service/scheduler/scheduler-custom-uber-pool-app.xml";
  }

  @Test
  public void customUberPoolConfig() {
    final SchedulerPoolsConfigFactory factory = getSchedulerPoolsConfigFactory();

    SchedulerPoolsConfig config = factory.getConfig().get();

    assertThat(config.getSchedulerPoolStrategy(), is(UBER));
    assertThat(config.getUberCorePoolSize().getAsInt(), is(1));
    assertThat(config.getUberMaxPoolSize().getAsInt(), is(9));
    assertThat(config.getUberQueueSize().getAsInt(), is(5));
    assertThat(config.getUberKeepAlive().getAsLong(), is(5L));

    assertEmpty(config.getCpuIntensivePoolSize());
    assertEmpty(config.getCpuIntensiveQueueSize());

    assertEmpty(config.getCpuLightPoolSize());
    assertEmpty(config.getCpuLightQueueSize());

    assertEmpty(config.getIoCorePoolSize());
    assertEmpty(config.getIoMaxPoolSize());
    assertEmpty(config.getIoQueueSize());
    assertEmpty(config.getIoKeepAlive());
  }
}
