/*
 * (c) 2003-2023 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.domain.service.scheduler;

import static java.util.Arrays.asList;
import static org.junit.Assert.fail;
import static org.junit.rules.ExpectedException.none;
import static org.mule.test.allure.AllureConstants.SchedulerServiceFeature.SCHEDULER_SERVICE;

import java.util.Collection;

import io.qameta.allure.Feature;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameter;

@Feature(SCHEDULER_SERVICE)
@RunWith(Parameterized.class)
public class SchedulerInvalidCustomPoolTestCase extends AbstractCustomSchedulerConfigTestCase {

  @Parameterized.Parameters(name = "{0}")
  public static Collection<Object[]> data() {
    return asList(new Object[][] {
        {
            "service/scheduler/scheduler-invalid-custom-pool-app.xml",
            "cpuLight, cpuIntensive and io thread pools cannot be configured When the 'UBER' poolStrategy is selected"
        },
        {
            "service/scheduler/scheduler-invalid-custom-pool-app.xml",
            "cpuLight, cpuIntensive and io thread pools cannot be configured When the 'UBER' poolStrategy is selected"
        },
        {
            "service/scheduler/scheduler-invalid-custom-pool-app2.xml",
            "All three (cpuLight, cpuIntensive and io thread pools) must be configured When the 'DEDICATED' poolStrategy is selected"
        }
    });
  }

  @Rule
  public ExpectedException expected = none();

  @Parameter
  public String configFile;

  @Parameter(1)
  public String expectedMessage;

  @Override
  protected String getConfigFile() {
    return configFile;
  }

  @Override
  protected void doSetUpBeforeMuleContextCreation() {
    expected.expectMessage(expectedMessage);
  }

  @Test
  public void invalidConfig() {
    fail("Config should have failed");
  }
}
