/*
 * (c) 2003-2023 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.domain.xa;

import static org.mule.runtime.core.api.config.MuleProperties.OBJECT_CLASSLOADER_REPOSITORY;

import static java.util.Collections.singletonMap;

import static com.google.common.collect.ImmutableSet.of;
import static org.hamcrest.Matchers.sameInstance;
import static org.junit.Assert.assertThat;

import org.mule.functional.junit4.DomainFunctionalTestCase;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;

import com.mulesoft.mule.runtime.bti.api.extension.BtiExtensionModelProvider;
import com.mulesoft.mule.runtime.core.api.extension.MuleEeExtensionModelProvider;

import java.util.Map;
import java.util.Optional;
import java.util.Set;

import org.junit.Test;

public class SharedXaTransactionManagerTestCase extends DomainFunctionalTestCase {

  public static final String APPLICATION_NAME = "app";

  @Override
  protected String getDomainConfig() {
    return "domain-config/bti-ts-config.xml";
  }

  @Override
  protected Map<String, Object> getDomainStartUpRegistryObjects() {
    // Verify inconsistency between mockito and bytebuddy for using a mock here
    return singletonMap(OBJECT_CLASSLOADER_REPOSITORY, new ClassLoaderRepository() {

      @Override
      public Optional<String> getId(ClassLoader classLoader) {
        return null;
      }

      @Override
      public Optional<ClassLoader> find(String classLoaderId) {
        return null;
      }
    });
  }

  @Override
  public ApplicationConfig[] getConfigResources() {
    return new ApplicationConfig[] {
        new ApplicationConfig(APPLICATION_NAME, "domain-config/app-with-shared-tx-manager-config.xml")
    };
  }

  @Test
  public void domainTransactionManagerIsSharedByApps() {
    assertThat(getMuleContextForApp(APPLICATION_NAME).getTransactionManager(),
               sameInstance(getMuleContextForDomain().getTransactionManager()));
  }

  @Override
  protected Set<ExtensionModel> getExtensionModels() {
    return of(MuleExtensionModelProvider.getExtensionModel(),
              MuleEeExtensionModelProvider.getExtensionModel(),
              BtiExtensionModelProvider.getExtensionModel());
  }
}
