/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.test.module.http.functional;

import com.mulesoft.test.module.http.functional.certificate.TestCertificate;
import com.mulesoft.test.module.http.functional.certificate.TestCertificateData;
import com.mulesoft.test.module.http.functional.certificate.TestCertificateProvider;
import com.vdurmont.semver4j.Semver;
import io.qameta.allure.Description;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mule.extension.http.api.HttpRequestAttributes;
import org.mule.extension.http.api.HttpRequestAttributesBuilder;
import org.mule.extension.http.api.certificate.CertificateData;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.serialization.SerializationProtocol;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.http.api.HttpService;
import org.mule.service.http.impl.service.HttpServiceImplementation;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;

public class HttpRequestAttributesKryoSerializationTestCase
extends MuleArtifactFunctionalTestCase {
    private static final String CERTIFICATE_CONTENT = "Some test content";
    private SchedulerService schedulerService = new SimpleUnitTestSupportSchedulerService();
    private HttpService httpService = new HttpServiceImplementation(this.schedulerService);
    private boolean isFeatureSupported = new Semver(HttpRequestAttributesKryoSerializationTestCase.getMavenProjectVersionProperty()).isGreaterThan(new Semver("4.1.4"));
    @Inject
    @Named(value="kryo.serializer")
    private ObjectSerializer kryoObjectSerializer;
    private static TestCertificate certificateMock;
    private HttpRequestAttributesBuilder baseBuilder = new HttpRequestAttributesBuilder().listenerPath("/listener/path").relativePath("/relative/path").version("1.0").scheme("scheme").method("GET").requestPath("/request/path").remoteAddress("http://10.1.2.5:8080/").localAddress("http://127.0.0.1:8080/").requestUri("http://127.0.0.1/gateway").headers(MultiMap.emptyMultiMap()).queryString("queryParam1=queryParam1&queryParam2=queryParam2").queryParams(MultiMap.emptyMultiMap()).uriParams(Collections.emptyMap());

    @BeforeClass
    public static void setup() {
        certificateMock = new TestCertificate(CERTIFICATE_CONTENT);
        Security.insertProviderAt(new TestCertificateProvider(), 1);
    }

    protected boolean doTestClassInjection() {
        return true;
    }

    protected void addBuilders(List<ConfigurationBuilder> builders) {
        super.addBuilders(builders);
        try {
            LifecycleUtils.startIfNeeded((Object)this.httpService);
        }
        catch (MuleException muleException) {
            // empty catch block
        }
    }

    protected Map<String, Object> getStartUpRegistryObjects() {
        return Collections.singletonMap(this.httpService.getName(), this.httpService);
    }

    protected String[] getConfigFiles() {
        return new String[0];
    }

    @Test
    @Description(value="Validate that Kryo can correctly serialize HttpRequestAttributes with lazy Certificate. This only works because the tests are ran with the latest runtime. These tests will fail from 4.1.1 to 4.1.4")
    public void withLazyResolvedCertificate() throws Exception {
        HttpRequestAttributes attributes = this.baseBuilder.clientCertificate(() -> {
            try {
                return new TestCertificateData(certificateMock);
            }
            catch (CertificateEncodingException e) {
                throw new RuntimeException(e);
            }
        }).build();
        this.assertSerialization(attributes);
    }

    @Test
    @Description(value="Validate that Kryo can correctly serialize HttpRequestAttributes with explicit Certificate. This only works because the tests are ran with the latest runtime. These tests will fail from 4.1.1 to 4.1.4")
    public void withExplicitCertificate() throws Exception {
        HttpRequestAttributes attributes = this.baseBuilder.clientCertificate((CertificateData)new TestCertificateData(certificateMock)).build();
        this.assertSerialization(attributes);
    }

    private HttpRequestAttributes serializeAndDeserialize(HttpRequestAttributes attributes) {
        SerializationProtocol protocol = this.kryoObjectSerializer.getInternalProtocol();
        return (HttpRequestAttributes)protocol.deserialize(protocol.serialize((Object)attributes));
    }

    private void assertSerialization(HttpRequestAttributes originalAttributes) {
        if (!this.isFeatureSupported) {
            originalAttributes.getClientCertificate();
        }
        HttpRequestAttributes processedAttributes = this.serializeAndDeserialize(originalAttributes);
        MatcherAssert.assertThat((Object)processedAttributes.getListenerPath(), (Matcher)IsEqual.equalTo((Object)originalAttributes.getListenerPath()));
        MatcherAssert.assertThat((Object)processedAttributes.getRelativePath(), (Matcher)IsEqual.equalTo((Object)originalAttributes.getRelativePath()));
        MatcherAssert.assertThat((Object)processedAttributes.getVersion(), (Matcher)IsEqual.equalTo((Object)originalAttributes.getVersion()));
        MatcherAssert.assertThat((Object)processedAttributes.getScheme(), (Matcher)IsEqual.equalTo((Object)originalAttributes.getScheme()));
        MatcherAssert.assertThat((Object)processedAttributes.getMethod(), (Matcher)IsEqual.equalTo((Object)originalAttributes.getMethod()));
        MatcherAssert.assertThat((Object)processedAttributes.getRequestPath(), (Matcher)IsEqual.equalTo((Object)originalAttributes.getRequestPath()));
        MatcherAssert.assertThat((Object)processedAttributes.getRemoteAddress(), (Matcher)IsEqual.equalTo((Object)originalAttributes.getRemoteAddress()));
        MatcherAssert.assertThat((Object)processedAttributes.getLocalAddress(), (Matcher)IsEqual.equalTo((Object)originalAttributes.getLocalAddress()));
        MatcherAssert.assertThat((Object)processedAttributes.getRequestUri(), (Matcher)IsEqual.equalTo((Object)originalAttributes.getRequestUri()));
        MatcherAssert.assertThat((Object)processedAttributes.getHeaders(), (Matcher)IsEqual.equalTo((Object)originalAttributes.getHeaders()));
        MatcherAssert.assertThat((Object)processedAttributes.getQueryString(), (Matcher)IsEqual.equalTo((Object)originalAttributes.getQueryString()));
        MatcherAssert.assertThat((Object)processedAttributes.getQueryParams(), (Matcher)IsEqual.equalTo((Object)originalAttributes.getQueryParams()));
        MatcherAssert.assertThat((Object)processedAttributes.getUriParams(), (Matcher)IsEqual.equalTo((Object)originalAttributes.getUriParams()));
        MatcherAssert.assertThat((Object)processedAttributes.getMaskedRequestPath(), (Matcher)IsEqual.equalTo((Object)originalAttributes.getMaskedRequestPath()));
        MatcherAssert.assertThat((Object)processedAttributes.getClientCertificate().toString(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)originalAttributes.getClientCertificate().toString())));
    }
}

