/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.test.module.http.functional;

import com.mulesoft.service.http.impl.service.HostNameResolver;
import com.mulesoft.service.http.impl.service.client.EEHttpClientConnectionManager;
import com.mulesoft.test.module.http.functional.AbstractNameResolvingTestCase;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.tck.junit4.rule.DynamicPort;

@Feature(value="HTTP Connector")
@Story(value="DNS lookup")
public class NameResolvingGrizzlyHttpClientTestCase
extends AbstractNameResolvingTestCase {
    protected static final String RESOLVED_PROXY_HOST_NAME = "resolvedProxyHost";
    protected static final String RESOLVED_HOST_NAME = "resolvedHost";
    private static InetAddress connectableAddress;
    private static InetAddress notConnectableAddress;
    private static List<InetAddress> allFailingAddresses;
    private static List<InetAddress> allConnectableAddresses;
    private static List<InetAddress> connectableOnRetryAddresses;
    private static List<InetAddress> connectableOnMultipleRetryAddresses;
    @Rule
    public DynamicPort proxyPort = new DynamicPort("proxyPort");
    @Rule
    public DynamicPort httpPort = new DynamicPort("httpPort");
    @Mock
    protected HostNameResolver hostNameResolver = (HostNameResolver)Mockito.mock(HostNameResolver.class);

    protected String getConfigFile() {
        return "name-resolving-grizzly-http-client.xml";
    }

    @BeforeClass
    public static void beforeClass() throws UnknownHostException {
        connectableAddress = InetAddress.getByName("127.0.0.1");
        notConnectableAddress = InetAddress.getByName("203.0.113.1");
        allFailingAddresses = Arrays.asList(notConnectableAddress, notConnectableAddress);
        connectableOnRetryAddresses = Arrays.asList(notConnectableAddress, connectableAddress);
        allConnectableAddresses = Arrays.asList(connectableAddress);
        connectableOnMultipleRetryAddresses = Arrays.asList(notConnectableAddress, notConnectableAddress, connectableAddress);
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        super.doSetUpBeforeMuleContextCreation();
        EEHttpClientConnectionManager.hostNameResolver = this.hostNameResolver;
    }

    protected void doTearDownAfterMuleContextDispose() throws Exception {
        super.doTearDownAfterMuleContextDispose();
        EEHttpClientConnectionManager.hostNameResolver = new HostNameResolver();
    }

    protected void validateRetryNoProxy() throws UnknownHostException {
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver)).getRotatedAddresses(RESOLVED_HOST_NAME);
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver, (VerificationMode)Mockito.never())).getAddresses(RESOLVED_HOST_NAME);
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver, (VerificationMode)Mockito.never())).getRotatedAddresses(RESOLVED_PROXY_HOST_NAME);
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver, (VerificationMode)Mockito.never())).getAddresses(RESOLVED_PROXY_HOST_NAME);
    }

    protected void validateRetryWithProxy() throws UnknownHostException {
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver)).getRotatedAddresses(RESOLVED_HOST_NAME);
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver)).getRotatedAddresses(RESOLVED_PROXY_HOST_NAME);
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver, (VerificationMode)Mockito.never())).getAddresses(RESOLVED_PROXY_HOST_NAME);
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver, (VerificationMode)Mockito.never())).getAddresses(RESOLVED_PROXY_HOST_NAME);
    }

    protected void validateRetryProxyOnly() throws UnknownHostException {
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver, (VerificationMode)Mockito.never())).getRotatedAddresses(RESOLVED_HOST_NAME);
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver, (VerificationMode)Mockito.never())).getAddresses(RESOLVED_HOST_NAME);
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver)).getRotatedAddresses(RESOLVED_PROXY_HOST_NAME);
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver, (VerificationMode)Mockito.never())).getAddresses(RESOLVED_PROXY_HOST_NAME);
    }

    @Test
    public void retriesThenConnects() throws Exception {
        Mockito.when((Object)this.hostNameResolver.getRotatedAddresses(RESOLVED_HOST_NAME)).thenReturn(connectableOnRetryAddresses);
        Mockito.when((Object)this.hostNameResolver.getAddresses(RESOLVED_HOST_NAME)).thenReturn(connectableOnRetryAddresses);
        this.flowRunner("outer").runAndVerify(new String[]{"inner"});
        this.validateRetryNoProxy();
    }

    @Test
    public void retriesMultipleRetriesThenConnects() throws Exception {
        Mockito.when((Object)this.hostNameResolver.getRotatedAddresses(RESOLVED_HOST_NAME)).thenReturn(connectableOnMultipleRetryAddresses);
        Mockito.when((Object)this.hostNameResolver.getAddresses(RESOLVED_HOST_NAME)).thenReturn(connectableOnMultipleRetryAddresses);
        this.flowRunner("outer").runAndVerify(new String[]{"inner"});
        this.validateRetryNoProxy();
    }

    @Test
    public void retriesThenFails() throws Exception {
        Mockito.when((Object)this.hostNameResolver.getRotatedAddresses(RESOLVED_HOST_NAME)).thenReturn(allFailingAddresses);
        Mockito.when((Object)this.hostNameResolver.getAddresses(RESOLVED_HOST_NAME)).thenReturn(allFailingAddresses);
        Exception e = this.flowRunner("outer").runExpectingException();
        Assert.assertThat((Object)ExceptionHelper.getRootException((Throwable)e), (Matcher)Matchers.instanceOf(SocketException.class));
        this.validateRetryNoProxy();
    }

    @Test
    public void retriesThenConnectsHttpProxy() throws Exception {
        Mockito.when((Object)this.hostNameResolver.getRotatedAddresses(RESOLVED_PROXY_HOST_NAME)).thenReturn(connectableOnRetryAddresses);
        Mockito.when((Object)this.hostNameResolver.getRotatedAddresses(RESOLVED_HOST_NAME)).thenReturn(allConnectableAddresses);
        Mockito.when((Object)this.hostNameResolver.getAddresses(RESOLVED_PROXY_HOST_NAME)).thenReturn(connectableOnRetryAddresses);
        Mockito.when((Object)this.hostNameResolver.getAddresses(RESOLVED_HOST_NAME)).thenReturn(allConnectableAddresses);
        this.flowRunner("outerWithProxy").runAndVerify(new String[]{"inner"});
        this.validateRetryWithProxy();
    }

    @Test
    public void retriesThenFailsHttpProxy() throws Exception {
        Mockito.when((Object)this.hostNameResolver.getRotatedAddresses(RESOLVED_PROXY_HOST_NAME)).thenReturn(allFailingAddresses);
        Mockito.when((Object)this.hostNameResolver.getRotatedAddresses(RESOLVED_HOST_NAME)).thenReturn(allConnectableAddresses);
        Mockito.when((Object)this.hostNameResolver.getAddresses(RESOLVED_PROXY_HOST_NAME)).thenReturn(allFailingAddresses);
        Mockito.when((Object)this.hostNameResolver.getAddresses(RESOLVED_HOST_NAME)).thenReturn(allConnectableAddresses);
        Exception e = this.flowRunner("outerWithProxy").runExpectingException();
        Assert.assertThat((Object)ExceptionHelper.getRootException((Throwable)e), (Matcher)Matchers.instanceOf(SocketException.class));
        this.validateRetryProxyOnly();
    }
}

