/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.test.module.http.functional;

import com.mulesoft.test.module.http.functional.AbstractHttpFunctionalTestCase;
import io.qameta.allure.Issue;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.mule.extension.http.api.error.HttpRequestFailedException;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.tck.junit4.rule.DynamicPort;

@Issue(value="W-14686211")
public class HttpClientConnectionsTestCase
extends AbstractHttpFunctionalTestCase {
    private static final String CONFIG_FILE = "http-client-connections.xml";
    private static final String MAX_CONNECTIONS_TIMEOUT_FLOW_NAME = "max-connections-timeout-flow";
    private static final String HTTP_NAMESPACE = "HTTP";
    private static final String CONNECTIVITY_ERROR_TYPE = "CONNECTIVITY";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port");
    @Rule
    public ExpectedError expectedError = ExpectedError.none();

    protected String getConfigFile() {
        return CONFIG_FILE;
    }

    @Test
    public void httpClientMaxConnectionsTimeout() throws Exception {
        this.expectedError.expectErrorType(HTTP_NAMESPACE, CONNECTIVITY_ERROR_TYPE);
        this.expectedError.expectCause(Matchers.isA(HttpRequestFailedException.class));
        this.expectedError.expectMessage(Matchers.containsString((String)"Connection refused"));
        this.flowRunner(MAX_CONNECTIONS_TIMEOUT_FLOW_NAME).run();
    }
}

