/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.test.module.http.functional;

import com.mulesoft.service.http.impl.service.HostNameResolver;
import com.mulesoft.service.http.impl.service.client.builder.NameResolvingRequestBuilder;
import com.mulesoft.test.module.http.functional.NameResolvingGrizzlyHttpClientTestCase;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import org.junit.After;
import org.junit.Before;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Feature(value="HTTP Connector")
@Story(value="DNS lookup")
public class NameResolvingGrizzlyHttpClientDisabledRoundRobinTestCase
extends NameResolvingGrizzlyHttpClientTestCase {
    @Before
    public void setUpRoundRobin() {
        NameResolvingRequestBuilder.setDisabledRoundRobinHosts(Arrays.asList("resolvedHost", "resolvedProxyHost"));
    }

    @After
    public void tearDown() {
        NameResolvingRequestBuilder.setDisabledRoundRobinHosts(Collections.emptyList());
    }

    @Override
    protected void validateRetryNoProxy() throws UnknownHostException {
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver, (VerificationMode)Mockito.atMost((int)2))).getRotatedAddresses("resolvedHost");
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver)).getAddresses("resolvedHost");
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver, (VerificationMode)Mockito.never())).getRotatedAddresses("resolvedProxyHost");
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver, (VerificationMode)Mockito.never())).getAddresses("resolvedProxyHost");
    }

    @Override
    protected void validateRetryWithProxy() throws UnknownHostException {
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver, (VerificationMode)Mockito.atMost((int)2))).getRotatedAddresses("resolvedHost");
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver, (VerificationMode)Mockito.atMost((int)2))).getRotatedAddresses("resolvedProxyHost");
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver)).getAddresses("resolvedHost");
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver)).getAddresses("resolvedProxyHost");
    }

    @Override
    protected void validateRetryProxyOnly() throws UnknownHostException {
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver, (VerificationMode)Mockito.never())).getRotatedAddresses("resolvedHost");
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver, (VerificationMode)Mockito.never())).getAddresses("resolvedHost");
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver, (VerificationMode)Mockito.atMost((int)2))).getRotatedAddresses("resolvedProxyHost");
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver)).getAddresses("resolvedProxyHost");
    }
}

