/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.test.module.http.functional;

import static java.util.Collections.singletonMap;
import static org.mule.runtime.core.api.lifecycle.LifecycleUtils.startIfNeeded;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.http.api.HttpService;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;

import com.mulesoft.service.http.impl.service.EEHttpServiceImplementation;

import java.util.List;
import java.util.Map;

public abstract class AbstractHttpFunctionalTestCase extends MuleArtifactFunctionalTestCase {

  // TODO - MULE-11119: Remove once the service is injected higher up on the hierarchy
  private SchedulerService schedulerService = new SimpleUnitTestSupportSchedulerService();
  private HttpService httpService = new EEHttpServiceImplementation(schedulerService);

  @Override
  protected Map<String, Object> getStartUpRegistryObjects() {
    return singletonMap(httpService.getName(), httpService);
  }

  @Override
  protected void addBuilders(List<ConfigurationBuilder> builders) {
    super.addBuilders(builders);
    try {
      startIfNeeded(httpService);
    } catch (MuleException e) {
      // do nothing
    }
  }

  @Override
  protected boolean mockHttpService() {
    return false;
  }

}
