/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.test.module.http.functional;

import static org.apache.commons.lang3.RandomStringUtils.randomAlphanumeric;
import static org.hamcrest.CoreMatchers.instanceOf;
import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.core.StringContains.containsString;
import static org.junit.Assert.assertThat;
import static org.mule.service.http.impl.service.client.GrizzlyHttpClient.CUSTOM_MAX_HTTP_PACKET_HEADER_SIZE;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.http.api.error.HttpRequestFailedException;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

@Feature("HTTP Connector")
@Story("Request header size limits")
public class HttpRequestHeaderSizeTestCase extends AbstractHttpFunctionalTestCase {

  private static final int SIZE_DELTA = 100;

  private static final Integer HEADER_SIZE = 10000;

  @Rule
  public ExpectedException expectedException = ExpectedException.none();

  @Rule
  public SystemProperty maxHeaderSectionSizeSystemProperty =
      new SystemProperty(CUSTOM_MAX_HTTP_PACKET_HEADER_SIZE, HEADER_SIZE.toString());

  @Rule
  public SystemProperty exceededContentValue =
      new SystemProperty("exceededContentValue", randomAlphanumeric(HEADER_SIZE + SIZE_DELTA));

  @Rule
  public SystemProperty notExceededContentValue =
      new SystemProperty("notExceededContentValue", randomAlphanumeric(HEADER_SIZE - SIZE_DELTA));

  @Rule
  public DynamicPort dynamicPort = new DynamicPort("port");

  @Override
  protected String getConfigFile() {
    return "http-requester-max-header-size-config.xml";
  }

  @Test
  public void exceptionIsThrownWhenMaxHeaderSizeIsExceeded() throws Exception {
    expectedException.expect(MuleException.class);
    expectedException.expectMessage(containsString("HTTP packet header is too large"));
    expectedException.expectCause(instanceOf(HttpRequestFailedException.class));
    runFlow("requestToListenerWithExceededHeaderFlow");
  }

  @Test
  public void maxHeaderSizeNotExceeded() throws Exception {
    Event event = runFlow("requestToListenerWithNotExceededHeaderFlow");
    HttpResponseAttributes responseAttributes = (HttpResponseAttributes) event.getMessage().getAttributes().getValue();
    String customHeader = responseAttributes.getHeaders().get("customheader");
    assertThat(customHeader.getBytes().length, is(HEADER_SIZE - SIZE_DELTA));
  }

}
