/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.test.module.http.functional;

import static java.util.Arrays.asList;
import static java.util.Collections.emptyList;
import static org.mockito.Mockito.atMost;
import static org.mockito.Mockito.never;
import static org.mockito.Mockito.verify;

import com.mulesoft.service.http.impl.service.client.builder.NameResolvingRequestBuilder;

import java.net.UnknownHostException;

import org.junit.After;
import org.junit.Before;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;

@Feature("HTTP Connector")
@Story("DNS lookup")
public class NameResolvingGrizzlyHttpClientDisabledRoundRobinTestCase extends NameResolvingGrizzlyHttpClientTestCase {

  @Before
  public void setUpRoundRobin() {
    NameResolvingRequestBuilder.setDisabledRoundRobinHosts(asList(RESOLVED_HOST_NAME, RESOLVED_PROXY_HOST_NAME));
  }

  @After
  public void tearDown() {
    NameResolvingRequestBuilder.setDisabledRoundRobinHosts(emptyList());
  }

  @Override
  protected void validateRetryNoProxy() throws UnknownHostException {
    verify(hostNameResolver, atMost(2)).getRotatedAddresses(RESOLVED_HOST_NAME);
    verify(hostNameResolver).getAddresses(RESOLVED_HOST_NAME);
    verify(hostNameResolver, never()).getRotatedAddresses(RESOLVED_PROXY_HOST_NAME);
    verify(hostNameResolver, never()).getAddresses(RESOLVED_PROXY_HOST_NAME);
  }

  @Override
  protected void validateRetryWithProxy() throws UnknownHostException {
    verify(hostNameResolver, atMost(2)).getRotatedAddresses(RESOLVED_HOST_NAME);
    verify(hostNameResolver, atMost(2)).getRotatedAddresses(RESOLVED_PROXY_HOST_NAME);
    verify(hostNameResolver).getAddresses(RESOLVED_HOST_NAME);
    verify(hostNameResolver).getAddresses(RESOLVED_PROXY_HOST_NAME);
  }

  @Override
  protected void validateRetryProxyOnly() throws UnknownHostException {
    verify(hostNameResolver, never()).getRotatedAddresses(RESOLVED_HOST_NAME);
    verify(hostNameResolver, never()).getAddresses(RESOLVED_HOST_NAME);
    verify(hostNameResolver, atMost(2)).getRotatedAddresses(RESOLVED_PROXY_HOST_NAME);
    verify(hostNameResolver).getAddresses(RESOLVED_PROXY_HOST_NAME);
  }
}
