/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.test.module.http.functional;

import com.mulesoft.test.module.http.functional.AbstractHttpFunctionalTestCase;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.StringContains;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.extension.http.api.error.HttpRequestFailedException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

@Feature(value="HTTP Connector")
@Story(value="Request header size limits")
public class HttpRequestHeaderSizeTestCase
extends AbstractHttpFunctionalTestCase {
    private static final int SIZE_DELTA = 100;
    private static final Integer HEADER_SIZE = 10000;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public SystemProperty maxHeaderSectionSizeSystemProperty = new SystemProperty("mule.http.client.headerSectionSize", HEADER_SIZE.toString());
    @Rule
    public SystemProperty exceededContentValue = new SystemProperty("exceededContentValue", RandomStringUtils.randomAlphanumeric((int)(HEADER_SIZE + 100)));
    @Rule
    public SystemProperty notExceededContentValue = new SystemProperty("notExceededContentValue", RandomStringUtils.randomAlphanumeric((int)(HEADER_SIZE - 100)));
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port");

    protected String getConfigFile() {
        return "http-requester-max-header-size-config.xml";
    }

    @Test
    public void exceptionIsThrownWhenMaxHeaderSizeIsExceeded() throws Exception {
        this.expectedException.expect(MuleException.class);
        this.expectedException.expectMessage(StringContains.containsString((String)"HTTP packet header is too large"));
        this.expectedException.expectCause(CoreMatchers.instanceOf(HttpRequestFailedException.class));
        this.runFlow("requestToListenerWithExceededHeaderFlow");
    }

    @Test
    public void maxHeaderSizeNotExceeded() throws Exception {
        CoreEvent event = this.runFlow("requestToListenerWithNotExceededHeaderFlow");
        HttpResponseAttributes responseAttributes = (HttpResponseAttributes)event.getMessage().getAttributes().getValue();
        String customHeader = (String)responseAttributes.getHeaders().get((Object)"customheader");
        Assert.assertThat((Object)customHeader.getBytes().length, (Matcher)CoreMatchers.is((Object)(HEADER_SIZE - 100)));
    }
}

