/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.test.module.http.functional;

import com.mulesoft.service.http.impl.service.HostNameResolver;
import com.mulesoft.service.http.impl.service.client.EEHttpClientConnectionManager;
import com.mulesoft.test.module.http.functional.AbstractHttpFunctionalTestCase;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLHandshakeException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mule.functional.junit4.matchers.ThrowableCauseMatcher;
import org.mule.runtime.api.exception.ExceptionHelper;
import org.mule.tck.junit4.rule.DynamicPort;

@Feature(value="HTTP Connector")
@Story(value="DNS lookup")
public class NameResolvingGrizzlyHttpClientTlsTestCase
extends AbstractHttpFunctionalTestCase {
    private static final String RESOLVED_HOST_NAME = "resolvedHost";
    private static final String LOCALHOST_HOST_NAME = "localhost";
    private static InetAddress connectableAddress;
    private static InetAddress notConnectableAddress;
    private static InetAddress notSANAddress;
    private static List<InetAddress> allFailingAddresses;
    private static List<InetAddress> allConnectableAddresses;
    private static List<InetAddress> connectableOnRetryAddresses;
    @Rule
    public ExpectedException socketException = ExpectedException.none();
    @Rule
    public DynamicPort proxyPort = new DynamicPort("proxyPort");
    @Rule
    public DynamicPort httpPort = new DynamicPort("httpPort");
    @Rule
    public DynamicPort httpsPort = new DynamicPort("httpsPort");
    private HostNameResolver hostNameResolver = (HostNameResolver)Mockito.mock(HostNameResolver.class, (MockSettings)Mockito.withSettings().lenient());

    @BeforeClass
    public static void beforeClass() throws UnknownHostException {
        connectableAddress = InetAddress.getByName("127.0.0.1");
        notConnectableAddress = InetAddress.getByName("203.0.113.1");
        notSANAddress = InetAddress.getLocalHost();
        allFailingAddresses = Arrays.asList(notConnectableAddress, notConnectableAddress);
        connectableOnRetryAddresses = Arrays.asList(notConnectableAddress, connectableAddress);
        allConnectableAddresses = Arrays.asList(connectableAddress);
    }

    protected String getConfigFile() {
        return "name-resolving-grizzly-http-client-tls.xml";
    }

    protected void doSetUpBeforeMuleContextCreation() throws Exception {
        super.doSetUpBeforeMuleContextCreation();
        EEHttpClientConnectionManager.hostNameResolver = this.hostNameResolver;
    }

    protected void doTearDownAfterMuleContextDispose() throws Exception {
        super.doTearDownAfterMuleContextDispose();
        EEHttpClientConnectionManager.hostNameResolver = new HostNameResolver();
    }

    @Test
    public void retriesThenConnects() throws Exception {
        Mockito.when((Object)this.hostNameResolver.getRotatedAddresses(LOCALHOST_HOST_NAME)).thenReturn(connectableOnRetryAddresses);
        this.flowRunner("outer").runAndVerify(new String[]{"inner"});
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver)).getRotatedAddresses(LOCALHOST_HOST_NAME);
    }

    @Test
    public void retriesThenFails() throws Exception {
        Mockito.when((Object)this.hostNameResolver.getRotatedAddresses(LOCALHOST_HOST_NAME)).thenReturn(allFailingAddresses);
        Exception e = this.flowRunner("outer").runExpectingException();
        Assert.assertThat((Object)ExceptionHelper.getRootException((Throwable)e), (Matcher)Matchers.instanceOf(SocketException.class));
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver)).getRotatedAddresses(LOCALHOST_HOST_NAME);
    }

    @Test
    public void validHostInUrlInvalidInSocket() throws Exception {
        Mockito.when((Object)this.hostNameResolver.getRotatedAddresses(LOCALHOST_HOST_NAME)).thenReturn(Arrays.asList(notSANAddress));
        this.flowRunner("outer").runAndVerify(new String[]{"inner"});
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver)).getRotatedAddresses(LOCALHOST_HOST_NAME);
    }

    @Test
    public void invalidHostInUrl() throws Exception {
        Mockito.when((Object)this.hostNameResolver.getRotatedAddresses(RESOLVED_HOST_NAME)).thenReturn(Arrays.asList(notSANAddress));
        Exception e = this.flowRunner("outerNotSANHost").runExpectingException();
        Assert.assertThat((Object)e.getCause(), (Matcher)ThrowableCauseMatcher.hasCause((Matcher)Matchers.instanceOf(SSLHandshakeException.class)));
        ((HostNameResolver)Mockito.verify((Object)this.hostNameResolver)).getRotatedAddresses(RESOLVED_HOST_NAME);
    }
}

