/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.test.module.http.functional;

import com.mulesoft.test.module.http.functional.AbstractHttpFunctionalTestCase;
import io.qameta.allure.Issue;
import java.security.cert.CRLReason;
import java.security.cert.CertificateRevokedException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

@Issue(value="W-15255505")
public class HttpRequesterStandardRevocationTestCase
extends AbstractHttpFunctionalTestCase {
    @Rule
    public DynamicPort httpPort = new DynamicPort("httpPort");
    @Rule
    public DynamicPort port = new DynamicPort("port");
    @Rule
    public DynamicPort httpsPort = new DynamicPort("httpsPort");
    private static final String REVOKED_CRL_FILE_PATH = "tls/crl/validCrl";
    @Rule
    public SystemProperty crlSystemProperty = new SystemProperty("crlPath", "tls/crl/validCrl");

    protected String getConfigFile() {
        return "http-requester-tls-revocation-file-config.xml";
    }

    @Test
    public void testServerCertifiedAndRevoked() throws Exception {
        try {
            ((FlowRunner)this.flowRunner("testFlowRevoked").withPayload((Object)"data")).keepStreamsOpen().run();
            Assert.fail((String)"CertificateRevokedException should have been thrown.");
        }
        catch (Exception e) {
            Throwable rootException = ExceptionUtils.getRootCause((Throwable)e);
            MatcherAssert.assertThat((Object)rootException, (Matcher)Is.is((Matcher)CoreMatchers.instanceOf(CertificateRevokedException.class)));
            MatcherAssert.assertThat((Object)((Object)((CertificateRevokedException)rootException).getRevocationReason()), (Matcher)Is.is((Object)((Object)CRLReason.KEY_COMPROMISE)));
        }
    }
}

