/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.runtime.api.lock;

import static java.util.Collections.singletonMap;
import static org.hamcrest.Matchers.not;
import static org.hamcrest.Matchers.nullValue;
import static org.junit.Assert.assertThat;

import org.mule.runtime.api.lock.LockFactory;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

import org.junit.Test;

import java.util.Map;

import javax.inject.Inject;

/**
 * Verifies injection of different standard Mule runtime objects.
 */
public class InjectionTestCase extends AbstractMuleContextTestCase {

  @Inject
  private LockFactoryUser lockFactoryUser;

  public InjectionTestCase() {
    setStartContext(true);
  }

  @Override
  protected boolean doTestClassInjection() {
    return true;
  }

  @Override
  protected Map<String, Object> getStartUpRegistryObjects() {
    return singletonMap("lockFactoryUser", new LockFactoryUser());
  }

  @Test
  public void lockFactory() {
    assertThat(lockFactoryUser, not(nullValue()));
  }

  public static class LockFactoryUser {

    @Inject
    private LockFactory lockFactory;

    public LockFactory getLockFactory() {
      return lockFactory;
    }
  }
}
