/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.component;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;
import static org.mule.runtime.api.component.ComponentIdentifier.buildFromStringRepresentation;
import static org.mule.runtime.api.component.TypedComponentIdentifier.ComponentType.OPERATION;
import static org.mule.runtime.api.component.TypedComponentIdentifier.ComponentType.SCOPE;
import static org.mule.runtime.api.component.TypedComponentIdentifier.ComponentType.UNKNOWN;
import static org.mule.test.allure.AllureConstants.ConfigurationComponentLocatorFeature.CONFIGURATION_COMPONENT_LOCATOR;
import static org.mule.test.allure.AllureConstants.ConfigurationComponentLocatorFeature.ConfigurationComponentTypeStore.COMPONENT_CONFIGURATION_TYPE;

import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.junit.Test;

@Feature(CONFIGURATION_COMPONENT_LOCATOR)
@Story(COMPONENT_CONFIGURATION_TYPE)
public class EeComponentTypeTestCase extends MuleArtifactFunctionalTestCase {

  @Override
  protected String getConfigFile() {
    return "component/component-type-config.xml";
  }

  @Test
  public void componentTypes() {
    assertThat(getComponentType(buildFromStringRepresentation("ee:transform")), is(OPERATION));
    assertThat(getComponentType(buildFromStringRepresentation("ee:invalidate-cache")), is(OPERATION));
    assertThat(getComponentType(buildFromStringRepresentation("ee:invalidate-key")), is(OPERATION));
    assertThat(getComponentType(buildFromStringRepresentation("ee:cache")), is(SCOPE));
    assertThat(getComponentType(buildFromStringRepresentation("ee:object-store-caching-strategy")), is(UNKNOWN));
  }

  @Test
  public void trackingComponentTypes() {
    assertThat(getComponentType(buildFromStringRepresentation("tracking:custom-event")), is(OPERATION));
    assertThat(getComponentType(buildFromStringRepresentation("tracking:transaction")), is(OPERATION));
  }

  private TypedComponentIdentifier.ComponentType getComponentType(ComponentIdentifier componentIdentifier) {
    return locator.find(componentIdentifier).get(0).getLocation().getComponentIdentifier().getType();
  }

}
