/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.component;

import static java.util.Arrays.asList;
import static org.hamcrest.Matchers.is;
import static org.hamcrest.core.IsNull.notNullValue;
import static org.junit.Assert.assertThat;
import static org.mule.runtime.api.util.MuleSystemProperties.MULE_DISABLE_PAYLOAD_STATISTICS;
import static org.mule.runtime.api.util.MuleSystemProperties.MULE_ENABLE_STATISTICS;
import static org.mule.test.allure.AllureConstants.SerializationFeature.SERIALIZATION;
import static org.mule.test.allure.AllureConstants.SerializationFeature.SerializationStory.STATISTICS;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;

import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;
import org.mule.functional.api.component.TestConnectorQueueHandler;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.management.stats.PayloadStatistics;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.runner.RunnerDelegateTo;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;

@Feature(SERIALIZATION)
@Story(STATISTICS)
@RunnerDelegateTo(Parameterized.class)
public class PayloadDecoratorThroughQueuesUsingKryoTestCase extends MuleArtifactFunctionalTestCase {

  @Rule
  public SystemProperty withStatistics = new SystemProperty(MULE_ENABLE_STATISTICS, "true");

  @Rule
  public SystemProperty withPayloadStatistics = new SystemProperty(MULE_DISABLE_PAYLOAD_STATISTICS, "false");

  private TestConnectorQueueHandler queueHandler;

  private Object payload;

  @Parameters
  public static Collection<Object[]> data() {
    return asList(new Object[][] {{asList("cat", "cow", "dog")},
        {new HashSet(asList("cat", "cow", "dog"))},
        {new Vector(asList("cat", "cow", "dog"))}
    });
  }

  @Before
  public void before() throws IOException {
    queueHandler = new TestConnectorQueueHandler(registry);
  }

  public PayloadDecoratorThroughQueuesUsingKryoTestCase(Object payload) {
    this.payload = payload;
  }

  @Override
  protected String getConfigFile() {
    return "component/payload-through-vm-config.xml";
  }

  @Test
  @Issue("MULE-18894")
  @Description("Assert statistics for a component that serializes the payload")
  public void testPayload() throws Exception {
    sendPayload("publishConsumeThroughVM", payload);
    assertThat(queueHandler.read("processed", RECEIVE_TIMEOUT), notNullValue());
    final PayloadStatistics stats =
        muleContext.getStatistics().getPayloadStatistics("publishConsumeThroughVM/processors/0");

    assertThat(stats.getComponentIdentifier(), is("vm:publish-consume"));

    assertThat(stats.getInvocationCount(), is(1L));

    assertThat(stats.getInputObjectCount(), is(3L));
    assertThat(stats.getInputByteCount(), is(0L));
    assertThat(stats.getOutputObjectCount(), is(0L));
  }

  private void sendPayload(String flowName, Object payload) throws Exception {
    flowRunner(flowName)
        .withPayload(payload)
        .withMediaType(MediaType.APPLICATION_JAVA)
        .run();
  }

}
