/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.config;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.CoreMatchers.nullValue;
import static org.junit.Assert.assertThat;
import static org.mule.runtime.api.component.location.Location.builderFromStringRepresentation;
import static org.mule.test.allure.AllureConstants.ArtifactAst.ARTIFACT_AST;
import static org.mule.test.allure.AllureConstants.ArtifactAst.ParameterAst.PARAMETER_AST;

import java.util.Map;

import javax.xml.namespace.QName;

import org.junit.Test;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.component.Component;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;

@Feature(ARTIFACT_AST)
@Story(PARAMETER_AST)
public class ConfigurationAnnotationsTestCase extends MuleArtifactFunctionalTestCase {

  private QName ANNOTATION_PARAMETERS = new QName("config", "componentParameters");

  @Override
  protected String[] getConfigFiles() {
    return new String[] {"transformers/annotations.xml"};
  }

  @Issue("MULE-18594")
  @Test
  public void noAnnotationsInProcessorsWithNullValue() {
    Component component = locator.find(builderFromStringRepresentation("testFlow/processors/0").build()).get();
    ((Map) component.getAnnotation(ANNOTATION_PARAMETERS)).values().forEach(v -> assertThat(v, is(not(nullValue()))));
  }

}
